/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Facet<C extends FacetConfiguration>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    public static final Facet[] EMPTY_ARRAY = new Facet[0];
    @NotNull
    private final FacetType myFacetType;
    @NotNull
    private final Module myModule;
    @NotNull
    private final C myConfiguration;
    private final Facet myUnderlyingFacet;
    private String myName;
    private boolean myImplicit;

    public Facet(@NotNull FacetType facetType, @NotNull Module module, String name, @NotNull C configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        this.myName = name;
        this.myFacetType = facetType;
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myUnderlyingFacet = underlyingFacet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final FacetType getType() {
        FacetType facetType = this.myFacetType;
        if (facetType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getType must not return null");
        }
        return facetType;
    }

    public final FacetTypeId getTypeId() {
        return this.myFacetType.getId();
    }

    public final Facet getUnderlyingFacet() {
        return this.myUnderlyingFacet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final C getConfiguration() {
        C c = this.myConfiguration;
        if (c == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getConfiguration must not return null");
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getModule must not return null");
        }
        return module;
    }

    public final boolean isImplicit() {
        return this.myImplicit;
    }

    public final void setImplicit(boolean implicit) {
        this.myImplicit = implicit;
    }

    public void initFacet() {
    }

    public void disposeFacet() {
    }

    @Override
    public final void dispose() {
        this.disposeFacet();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String getName() {
        return this.myName;
    }

    final void setName(String name) {
        this.myName = name;
    }
}

