/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NotNull;

public abstract class PsiFileBase
extends PsiFileImpl {
    private static final Logger LOG = Logger.getInstance("#com.intellij.extapi.psi.PsiFileBase");
    @NotNull
    private Language myLanguage;
    @NotNull
    private ParserDefinition myParserDefinition;

    protected PsiFileBase(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.<init> must not be null");
        }
        super(viewProvider);
        this.initLanguage(language);
    }

    @Deprecated
    protected PsiFileBase(Project project, VirtualFile virtualFile, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.<init> must not be null");
        }
        super((PsiManagerImpl)PsiManager.getInstance(project));
        this.initLanguage(language);
    }

    @Deprecated
    protected PsiFileBase(Project project, String name, CharSequence text, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.<init> must not be null");
        }
        super((PsiManagerImpl)PsiManager.getInstance(project));
        this.initLanguage(language);
    }

    private void initLanguage(Language language) {
        this.myLanguage = language;
        ParserDefinition parserDefinition = language.getParserDefinition();
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null.");
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        this.init(nodeType, nodeType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiFileBase.getLanguage must not return null");
        }
        return language;
    }

    public final Lexer createLexer() {
        return this.myParserDefinition.createLexer(this.getProject());
    }

    protected final FileElement createFileElement(CharSequence docText) {
        return super.createFileElement(docText);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.accept must not be null");
        }
        visitor.visitFile((PsiFile)((Object)this));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ParserDefinition getParserDefinition() {
        ParserDefinition parserDefinition = this.myParserDefinition;
        if (parserDefinition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiFileBase.getParserDefinition must not return null");
        }
        return parserDefinition;
    }
}

