/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.resolve.ResolveUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PsiElementBase
extends ElementBase
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance("#com.intellij.extapi.psi.PsiElementBase");

    @Override
    public PsiElement copy() {
        return (PsiElement)this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.add must not be null");
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.addBefore must not be null");
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.addAfter must not be null");
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.checkAdd must not be null");
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.addRangeBefore must not be null");
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.replace must not be null");
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull PsiSubstitutor substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.processDeclarations must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.processDeclarations must not be null");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiElementBase.getProject must not return null");
        }
        return project;
    }

    @Override
    public PsiManager getManager() {
        PsiElement parent = this.getParent();
        return parent != null ? parent.getManager() : null;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return parent.getContainingFile();
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this, (int)offset);
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.textMatches must not be null");
        }
        return Comparing.equal((CharSequence)this.getText(), text, true);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.textMatches must not be null");
        }
        return this.getText().equals(element.getText());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.accept must not be null");
        }
        visitor.visitElement(this);
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiElementBase.acceptChildren must not be null");
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    @Override
    public boolean isValid() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isValid();
    }

    @Override
    public boolean isWritable() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isWritable();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiElementBase.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Override
    public PsiElement getContext() {
        return ResolveUtil.getContext((PsiElement)this);
    }

    @Override
    public boolean isPhysical() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isPhysical();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ((PsiManagerEx)this.getManager()).getFileManager().getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiElementBase.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = this.getManager().getSearchHelper().getUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiElementBase.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)this);
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return true;
    }

    @Override
    public boolean canNavigateToSource() {
        Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)this);
        return descriptor != null && descriptor.canNavigateToSource();
    }

    @Override
    public FileStatus getFileStatus() {
        if (!this.isPhysical()) {
            return FileStatus.NOT_CHANGED;
        }
        PsiFile contFile = this.getContainingFile();
        if (contFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        VirtualFile vFile = contFile.getVirtualFile();
        return vFile != null ? FileStatusManager.getInstance(this.getProject()).getStatus(vFile) : FileStatus.NOT_CHANGED;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiElementBase.findChildrenByClass must not return null");
        }
        return objectArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass) {
        T child = this.findChildByClass(aClass);
        if (child == null) {
            LOG.assertTrue(false, this.getText());
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiElementBase.findNotNullChildByClass must not return null");
        }
        return t;
    }
}

