/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.PsiElementBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class MetadataPsiElementBase
extends PsiElementBase {
    private final PsiElement mySourceElement;

    public MetadataPsiElementBase(PsiElement sourceElement) {
        this.mySourceElement = sourceElement;
    }

    public TextRange getTextRange() {
        return this.mySourceElement.getTextRange();
    }

    public int getStartOffsetInParent() {
        PsiElement parent = this.getParent();
        return parent == null ? 0 : this.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset();
    }

    public int getTextLength() {
        return this.mySourceElement.getTextLength();
    }

    public int getTextOffset() {
        return this.mySourceElement.getTextOffset();
    }

    public String getText() {
        return this.mySourceElement.getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.mySourceElement.textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/MetadataPsiElementBase.textToCharArray must not return null");
        }
        return cArray;
    }

    public boolean textContains(char c) {
        return this.mySourceElement.textContains(c);
    }

    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }
}

