/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.PsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTWrapperPsiElement
extends PsiElementBase {
    private ASTNode myNode;

    public ASTWrapperPsiElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTWrapperPsiElement.<init> must not be null");
        }
        this.myNode = node;
    }

    public PsiManagerEx getManager() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return (PsiManagerEx)parent.getManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            psiElementArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTWrapperPsiElement.getChildren must not return null");
            return psiElementArray;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        psiElementArray = result.toArray(new PsiElement[result.size()]);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTWrapperPsiElement.getChildren must not return null");
    }

    @Override
    public PsiElement getParent() {
        return SharedImplUtil.getParent((ASTNode)this.myNode);
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild((ASTNode)this.myNode);
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild((ASTNode)this.myNode);
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling((ASTNode)this.myNode);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling((ASTNode)this.myNode);
    }

    @Override
    public TextRange getTextRange() {
        return this.myNode.getTextRange();
    }

    @Override
    public int getStartOffsetInParent() {
        return this.myNode.getStartOffset() - this.myNode.getTreeParent().getStartOffset();
    }

    @Override
    public int getTextLength() {
        return this.myNode.getTextLength();
    }

    @Override
    public PsiElement findElementAt(int offset) {
        ASTNode treeElement = this.myNode.findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)treeElement);
    }

    @Override
    public int getTextOffset() {
        return this.myNode.getStartOffset();
    }

    @Override
    public String getText() {
        return this.myNode.getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myNode.getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTWrapperPsiElement.textToCharArray must not return null");
        }
        return cArray;
    }

    @Override
    public boolean textContains(char c) {
        return this.myNode.textContains(c);
    }

    @Override
    public <T> T getCopyableUserData(Key<T> key) {
        return this.myNode.getCopyableUserData(key);
    }

    @Override
    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.myNode.putCopyableUserData(key, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTWrapperPsiElement.getNode must not return null");
        }
        return aSTNode;
    }

    public void subtreeChanged() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myNode.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTWrapperPsiElement.getLanguage must not return null");
        }
        return language;
    }

    @Nullable
    protected PsiElement findChildByType(IElementType type) {
        ASTNode node = this.getNode().findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    protected PsiElement findChildByType(TokenSet type) {
        ASTNode node = TreeUtil.findChild((ASTNode)this.getNode(), (TokenSet)type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    protected PsiElement findChildByFilter(TokenSet tokenSet) {
        ASTNode[] nodes = this.getNode().getChildren(tokenSet);
        return nodes == null || nodes.length == 0 ? null : nodes[0].getPsi();
    }

    protected PsiElement[] findChildrenByType(IElementType elementType, Class<? extends PsiElement> arrayClass) {
        return ContainerUtil.map2Array(this.getNode().getChildren(TokenSet.create(elementType)), arrayClass, new Function<ASTNode, PsiElement>(){

            @Override
            public PsiElement fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    protected PsiElement[] findChildrenByType(TokenSet elementType, Class<? extends PsiElement> arrayClass) {
        return ContainerUtil.map2Array(this.getNode().getChildren(elementType), arrayClass, new Function<ASTNode, PsiElement>(){

            @Override
            public PsiElement fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }
}

