/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.CommonBundle;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvVariablesTable
extends Observable {
    private final List<EnvironmentVariable> myVariables = new ArrayList<EnvironmentVariable>();
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private ColumnInfo NAME = new ColumnInfo<EnvironmentVariable, String>("Name"){

        @Override
        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getName();
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return environmentVariable.getNameIsWriteable();
        }

        @Override
        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setName(s);
            EnvVariablesTable.this.setModified();
        }
    };
    private ColumnInfo VALUE = new ColumnInfo<EnvironmentVariable, String>("Value"){

        @Override
        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getValue();
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return !environmentVariable.getIsPredefined();
        }

        @Override
        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setValue(s);
            EnvVariablesTable.this.setModified();
        }
    };
    private final TableView myTableVeiw = new TableView(new ListTableModel(this.NAME, this.VALUE));
    private boolean myIsEnabled = true;

    public EnvVariablesTable() {
        this.myTableVeiw.getTableViewModel().setSortable(false);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTableVeiw.getComponent()), "Center");
        JComponent toolbarComponent = this.createToolbar();
        this.myPanel.add((Component)toolbarComponent, "North");
        this.myTableVeiw.getComponent().setSelectionMode(0);
    }

    private void setModified() {
        this.setChanged();
        this.notifyObservers();
    }

    private JComponent createToolbar() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(new AddAction());
        actions.add(new DeleteAction());
        JComponent toolbarComponent = ActionManager.getInstance().createActionToolbar("unknown", actions, true).getComponent();
        return toolbarComponent;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void setEnabled() {
        this.myTableVeiw.getComponent().setEnabled(true);
        this.myIsEnabled = true;
    }

    public void setDisabled() {
        this.myTableVeiw.getComponent().setEnabled(false);
        this.myIsEnabled = false;
    }

    public void setValues(List<EnvironmentVariable> envVariables) {
        this.myVariables.clear();
        for (EnvironmentVariable envVariable : envVariables) {
            this.myVariables.add(envVariable.clone());
        }
        this.myTableVeiw.getTableViewModel().setItems(this.myVariables);
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.myVariables;
    }

    public void refreshValues() {
        this.myTableVeiw.getComponent().repaint();
    }

    private EnvironmentVariable getSelection() {
        int selIndex = this.myTableVeiw.getComponent().getSelectionModel().getMinSelectionIndex();
        if (selIndex < 0) {
            return null;
        }
        return this.myVariables.get(selIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddAction
    extends AnAction {
        public AddAction() {
            super(CommonBundle.message("button.add", new Object[0]), null, IconLoader.getIcon("/general/add.png"));
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(EnvVariablesTable.this.myIsEnabled);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            EnvVariablesTable.this.myTableVeiw.stopEditing();
            EnvVariablesTable.this.setModified();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EnvVariablesTable.this.myVariables.add(new EnvironmentVariable(AddAction.this.getUniqueName(), "", false));
                    EnvVariablesTable.this.myTableVeiw.getTableViewModel().setItems(EnvVariablesTable.this.myVariables);
                    EnvVariablesTable.this.myTableVeiw.getComponent().editCellAt(0, EnvVariablesTable.this.myVariables.size() - 1);
                }
            });
        }

        private String getUniqueName() {
            Set<String> names = this.collectAllNames();
            int i = 2;
            String newName;
            while (names.contains(newName = "EnvVar" + i)) {
                ++i;
            }
            return newName;
        }

        private Set<String> collectAllNames() {
            HashSet<String> result = new HashSet<String>();
            Iterator i$ = EnvVariablesTable.this.myVariables.iterator();
            while (i$.hasNext()) {
                EnvironmentVariable myVariable;
                EnvironmentVariable environmentVariable = myVariable = (EnvironmentVariable)i$.next();
                result.add(environmentVariable.getName());
            }
            return result;
        }
    }

    private final class DeleteAction
    extends AnAction {
        public DeleteAction() {
            super(CommonBundle.message("button.delete", new Object[0]), null, IconLoader.getIcon("/general/remove.png"));
        }

        public void update(AnActionEvent e) {
            EnvironmentVariable selection = EnvVariablesTable.this.getSelection();
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(selection != null && EnvVariablesTable.this.myIsEnabled && !selection.getIsPredefined());
        }

        public void actionPerformed(AnActionEvent e) {
            EnvVariablesTable.this.myTableVeiw.stopEditing();
            EnvVariablesTable.this.setModified();
            EnvironmentVariable selected = EnvVariablesTable.this.getSelection();
            if (selected != null) {
                int selectedIndex = EnvVariablesTable.this.myVariables.indexOf(selected);
                EnvVariablesTable.this.myVariables.remove(selected);
                EnvVariablesTable.this.myTableVeiw.getTableViewModel().setItems(EnvVariablesTable.this.myVariables);
                int prev = selectedIndex - 1;
                if (prev >= 0) {
                    EnvVariablesTable.this.myTableVeiw.getComponent().getSelectionModel().setSelectionInterval(prev, prev);
                } else if (selectedIndex < EnvVariablesTable.this.myVariables.size()) {
                    EnvVariablesTable.this.myTableVeiw.getComponent().getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
                }
            }
        }
    }
}

