/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;

public class RunContentDescriptor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.ui.RunContentDescriptor");
    private final ExecutionConsole myExecutionConsole;
    private final ProcessHandler myProcessHandler;
    private final JComponent myComponent;
    private final String myDisplayName;
    private Content myContent;

    public RunContentDescriptor(ExecutionConsole executionConsole, ProcessHandler processHandler, JComponent component, String displayName) {
        LOG.assertTrue(executionConsole != null || ApplicationManager.getApplication().isUnitTestMode());
        this.myExecutionConsole = executionConsole;
        this.myProcessHandler = processHandler;
        this.myComponent = component;
        this.myDisplayName = displayName;
    }

    public ExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public void dispose() {
        this.myExecutionConsole.dispose();
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public boolean isContentReuseProhibited() {
        return false;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void setAttachedContent(Content content) {
        this.myContent = content;
    }

    public Content getAttachedContent() {
        return this.myContent;
    }
}

