/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.runners.JavaProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;

public class CloseAction
extends AnAction {
    private JavaProgramRunner myRunner;
    private RunContentDescriptor myContentDescriptor;
    private final Project myProject;

    public CloseAction(JavaProgramRunner runner, RunContentDescriptor contentDescriptor, Project project) {
        this.myRunner = runner;
        this.myContentDescriptor = contentDescriptor;
        this.myProject = project;
        this.copyFrom(ActionManager.getInstance().getAction("CloseActiveTab"));
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setIcon(IconLoader.getIcon("/actions/cancel.png"));
        templatePresentation.setText(ExecutionBundle.message("close.tab.action.name", new Object[0]));
        templatePresentation.setDescription(null);
    }

    public void actionPerformed(AnActionEvent e) {
        if (this.myContentDescriptor == null) {
            return;
        }
        boolean removedOk = ExecutionManager.getInstance(this.myProject).getContentManager().removeRunContent(this.myRunner, this.myContentDescriptor);
        if (removedOk) {
            this.myContentDescriptor = null;
            this.myRunner = null;
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.myContentDescriptor != null);
    }
}

