/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.openapi.diagnostic.Logger;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class RunnerInfo {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.runners.RunnerInfo");
    private final String myId;
    private final String myDescription;
    private final Icon myIcon;
    private final Icon myToolWindowIcon;
    private final String myHelpId;
    private final String myToolWindowId;

    public RunnerInfo(String id, String description, Icon icon, Icon toolWindowIcon, String toolWindowId, @NonNls String helpId) {
        LOG.assertTrue(id != null);
        LOG.assertTrue(description != null);
        LOG.assertTrue(toolWindowId != null);
        this.myId = id;
        this.myDescription = description;
        this.myIcon = icon;
        this.myToolWindowIcon = toolWindowIcon;
        this.myToolWindowId = toolWindowId;
        this.myHelpId = helpId;
    }

    public RunnerInfo(String id, String description, Icon icon, String toolWindowId, @NonNls String helpId) {
        this(id, description, icon, icon, toolWindowId, helpId);
    }

    public String getId() {
        return this.myId;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getToolWindowIcon() {
        return this.myToolWindowIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    @NonNls
    public String getRunContextActionId() {
        return "runContext." + this.getId();
    }

    public String getRunActionId() {
        return this.getId();
    }

    public String getStartActionText() {
        return this.getId();
    }

    public Icon getDisabledIcon() {
        return this.myIcon;
    }

    public Icon getEnabledIcon() {
        return this.myIcon;
    }
}

