/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSProcessHandler
extends ProcessHandler {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.OSProcessHandler");
    private final Process myProcess;
    private final String myCommandLine;
    private final ProcessWaitFor myWaitFor;
    private static ExecutorService ourThreadExecutorsService = null;

    public static Future<?> executeOnPooledThread(Runnable task) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            return application.executeOnPooledThread(task);
        }
        if (ourThreadExecutorsService == null) {
            ourThreadExecutorsService = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "OSProcessHandler pooled thread");
                }
            });
        }
        return ourThreadExecutorsService.submit(task);
    }

    public OSProcessHandler(Process process, String commandLine) {
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myWaitFor = new ProcessWaitFor(process);
    }

    public Process getProcess() {
        return this.myProcess;
    }

    @Override
    public void startNotify() {
        final ReadProcessThread stdoutThread = new ReadProcessThread(this.createProcessOutReader()){

            protected void textAvailable(String s) {
                OSProcessHandler.this.notifyTextAvailable(s, ProcessOutputTypes.STDOUT);
            }
        };
        final ReadProcessThread stderrThread = new ReadProcessThread(this.createProcessErrReader()){

            protected void textAvailable(String s) {
                OSProcessHandler.this.notifyTextAvailable(s, ProcessOutputTypes.STDERR);
            }
        };
        this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                try {
                    final Future<?> stdOutReadingFuture = OSProcessHandler.executeOnPooledThread(stdoutThread);
                    final Future<?> stdErrReadingFuture = OSProcessHandler.executeOnPooledThread(stderrThread);
                    Runnable action = new Runnable(){

                        public void run() {
                            int exitCode = 0;
                            try {
                                exitCode = OSProcessHandler.this.myWaitFor.waitFor();
                                stderrThread.setProcessTerminated(true);
                                stdoutThread.setProcessTerminated(true);
                                stdErrReadingFuture.get();
                                stdOutReadingFuture.get();
                            }
                            catch (InterruptedException e) {
                            }
                            catch (ExecutionException executionException) {
                                // empty catch block
                            }
                            OSProcessHandler.this.onOSProcessTerminated(exitCode);
                        }
                    };
                    OSProcessHandler.executeOnPooledThread(action);
                }
                finally {
                    OSProcessHandler.this.removeProcessListener(this);
                }
            }
        });
        super.startNotify();
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected Reader createProcessOutReader() {
        return new BufferedReader(new InputStreamReader(this.myProcess.getInputStream(), this.getCharset()));
    }

    protected Reader createProcessErrReader() {
        return new BufferedReader(new InputStreamReader(this.myProcess.getErrorStream(), this.getCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.myProcess.destroy();
        }
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            public void run() {
                OSProcessHandler.this.closeStreams();
                OSProcessHandler.this.myWaitFor.detach();
                OSProcessHandler.this.notifyProcessDetached();
            }
        };
        OSProcessHandler.executeOnPooledThread(runnable);
    }

    private void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    public String getCommandLine() {
        return this.myCommandLine;
    }

    public Charset getCharset() {
        return CharsetToolkit.getIDEOptionsCharset();
    }

    private static abstract class ReadProcessThread
    implements Runnable {
        private static final int NOTIFY_TEXT_DELAY = 300;
        private final Reader myReader;
        private final StringBuffer myBuffer = new StringBuffer();
        private final Alarm myAlarm;
        private boolean myIsClosed = false;
        private boolean myIsProcessTerminated = false;

        public ReadProcessThread(Reader reader) {
            this.myReader = reader;
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        }

        public synchronized boolean isProcessTerminated() {
            return this.myIsProcessTerminated;
        }

        public synchronized void setProcessTerminated(boolean isProcessTerminated) {
            this.myIsProcessTerminated = isProcessTerminated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setPriority(10);
            try {
                this.myAlarm.addRequest(new Runnable(){

                    public void run() {
                        if (!ReadProcessThread.this.isClosed()) {
                            ReadProcessThread.this.myAlarm.addRequest(this, 300);
                            ReadProcessThread.this.checkTextAvailable();
                        }
                    }
                }, 300);
                try {
                    int c;
                    while (!this.isClosed() && (c = this.readNextByte()) != -1) {
                        StringBuffer stringBuffer = this.myBuffer;
                        synchronized (stringBuffer) {
                            this.myBuffer.append((char)c);
                        }
                        if (c != 10) continue;
                        this.checkTextAvailable();
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                    e.printStackTrace();
                }
                this.close();
            }
            finally {
                Thread.currentThread().setPriority(5);
            }
        }

        private int readNextByte() {
            try {
                while (!this.myReader.ready()) {
                    if (this.isProcessTerminated()) {
                        return -1;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ignore) {}
                }
                return this.myReader.read();
            }
            catch (IOException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTextAvailable() {
            StringBuffer stringBuffer = this.myBuffer;
            synchronized (stringBuffer) {
                if (this.myBuffer.length() == 0) {
                    return;
                }
                String s = this.myBuffer.substring(0, this.myBuffer.length());
                this.myBuffer.setLength(0);
                this.textAvailable(s);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            ReadProcessThread readProcessThread = this;
            synchronized (readProcessThread) {
                if (this.isClosed()) {
                    return;
                }
                this.myIsClosed = true;
            }
            try {
                this.myReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.checkTextAvailable();
        }

        protected abstract void textAvailable(String var1);

        private synchronized boolean isClosed() {
            return this.myIsClosed;
        }
    }

    private static class ProcessWaitFor {
        private final Semaphore myWaitSemaphore = new Semaphore();
        private final Future<?> myWaitForThreadFuture;
        private int myExitCode;

        public void detach() {
            this.myWaitForThreadFuture.cancel(true);
            this.myWaitSemaphore.up();
        }

        public ProcessWaitFor(final Process process) {
            this.myWaitSemaphore.down();
            Runnable action = new Runnable(){

                public void run() {
                    try {
                        ProcessWaitFor.this.myExitCode = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProcessWaitFor.this.myWaitSemaphore.up();
                }
            };
            this.myWaitForThreadFuture = OSProcessHandler.executeOnPooledThread(action);
        }

        public int waitFor() {
            this.myWaitSemaphore.waitFor();
            return this.myExitCode;
        }
    }
}

