/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExceptionFilter
implements Filter {
    private final Project myProject;
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);

    public ExceptionFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/filters/ExceptionFilter.<init> must not be null");
        }
        this.myProject = project;
    }

    public Filter.Result applyFilter(String line, int textEndOffset) {
        int rparenthIndex;
        int atIndex;
        if (line.startsWith(AT_PREFIX)) {
            atIndex = 0;
        } else {
            atIndex = line.indexOf(STANDALONE_AT);
            if (atIndex < 0) {
                atIndex = line.indexOf(AT_PREFIX);
            }
            if (atIndex < 0) {
                return null;
            }
        }
        int lparenthIndex = line.indexOf(40, atIndex);
        if (lparenthIndex < 0) {
            return null;
        }
        int lastDotIndex = line.lastIndexOf(46, lparenthIndex);
        if (lastDotIndex < 0 || lastDotIndex < atIndex) {
            return null;
        }
        String className = line.substring(atIndex + AT.length() + 1, lastDotIndex).trim();
        int dollarIndex = className.indexOf(36);
        if (dollarIndex >= 0) {
            className = className.substring(0, dollarIndex);
        }
        if ((rparenthIndex = line.indexOf(41, lparenthIndex)) < 0) {
            return null;
        }
        String fileAndLine = line.substring(lparenthIndex + 1, rparenthIndex).trim();
        int colonIndex = fileAndLine.lastIndexOf(58);
        if (colonIndex < 0) {
            return null;
        }
        String lineString = fileAndLine.substring(colonIndex + 1);
        try {
            int lineNumber = Integer.parseInt(lineString);
            PsiManager manager = PsiManager.getInstance(this.myProject);
            PsiClass aClass = manager.findClass(className, GlobalSearchScope.allScope(this.myProject));
            if (aClass == null) {
                return null;
            }
            PsiFile file = (PsiFile)aClass.getContainingFile().getNavigationElement();
            if (file == null) {
                return null;
            }
            int textStartOffset = textEndOffset - line.length();
            int highlightStartOffset = textStartOffset + lparenthIndex + 1;
            int highlightEndOffset = textStartOffset + rparenthIndex;
            VirtualFile virtualFile = file.getVirtualFile();
            OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(this.myProject, virtualFile, lineNumber - 1);
            TextAttributes attributes = HYPERLINK_ATTRIBUTES.clone();
            if (!ProjectRootManager.getInstance(this.myProject).getFileIndex().isInContent(virtualFile)) {
                Color color = UIUtil.getTextInactiveTextColor();
                attributes.setForegroundColor(color);
                attributes.setEffectColor(color);
            }
            return new Filter.Result(highlightStartOffset, highlightEndOffset, info, attributes);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

