/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import java.io.File;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CoverageEnabledConfiguration
extends ModuleBasedConfiguration {
    private static final Logger LOG = Logger.getInstance("com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration");
    private boolean myIsCoverageEnabled = false;
    private String[] myCoveragePatterns;
    private boolean myIsMergeWithPreviousResults = this.isMergeDataByDefault();
    @NonNls
    private static String COVERAGE_PATTERN_ELEMENT_NAME = "pattern";
    @NonNls
    private static String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    private static String COVERAGE_MERGE_ATTRIBUTE_NAME = "merge";
    @NonNls
    private static final String COVERAGE_DIR = "coverage";
    @NonNls
    private static final String COVERAGE_EXT = ".es";

    public CoverageEnabledConfiguration(String name, RunConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(name, configurationModule, factory);
    }

    protected abstract boolean isMergeDataByDefault();

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myIsCoverageEnabled = Boolean.valueOf(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        this.myIsMergeWithPreviousResults = Boolean.valueOf(element.getAttributeValue(COVERAGE_MERGE_ATTRIBUTE_NAME));
        List children = element.getChildren(COVERAGE_PATTERN_ELEMENT_NAME);
        if (children.size() > 0) {
            this.myCoveragePatterns = new String[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element e = (Element)children.get(i);
                Attribute pattern = e.getAttribute("value");
                this.myCoveragePatterns[i] = pattern.getValue();
            }
        }
    }

    public boolean isCoverageEnabled() {
        return this.myIsCoverageEnabled;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.myIsCoverageEnabled = isCoverageEnabled;
    }

    public String[] getCoveragePatterns() {
        return this.myCoveragePatterns;
    }

    public void setCoveragePatterns(String[] coveragePatterns) {
        this.myCoveragePatterns = coveragePatterns;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myIsCoverageEnabled));
        element.setAttribute(COVERAGE_MERGE_ATTRIBUTE_NAME, String.valueOf(this.myIsMergeWithPreviousResults));
        if (this.myCoveragePatterns != null) {
            for (String pattern : this.myCoveragePatterns) {
                Element patternElement = new Element(COVERAGE_PATTERN_ELEMENT_NAME);
                element.addContent(patternElement);
                patternElement.setAttribute("value", pattern);
            }
        }
    }

    @NotNull
    public abstract String getCoverageFileName();

    public void appendCoverageArgument(JavaParameters javaParameters) {
        StringBuffer argument = new StringBuffer("-javaagent:");
        argument.append(PathManager.getLibPath());
        argument.append(File.separator);
        argument.append("emma-agent.jar=");
        String[] patterns = this.getCoveragePatterns();
        if (patterns != null && patterns.length > 0) {
            argument.append("-f ");
            for (int i = 0; i < patterns.length; ++i) {
                if (i > 0) {
                    argument.append(",");
                }
                String pattern = patterns[i];
                if (!(pattern = pattern.replace('.', '/')).endsWith("/*")) {
                    argument.append(pattern).append(",").append(pattern).append("$*");
                    continue;
                }
                argument.append(pattern);
            }
            argument.append(" ");
        }
        argument.append("-o ");
        String coverageFilePath = this.getCoverageFilePath();
        if (coverageFilePath.indexOf(32) < 0) {
            argument.append(coverageFilePath);
        } else if (SystemInfo.isWindows) {
            argument.append("\\\"").append(coverageFilePath).append("\\\"");
        } else {
            argument.append("\"").append(coverageFilePath).append("\"");
        }
        javaParameters.getVMParametersList().add(argument.toString());
    }

    @NonNls
    public String getCoverageFilePath() {
        return PathManager.getSystemPath() + File.separator + COVERAGE_DIR + File.separator + this.getProject().getName() + '$' + this.getName() + '$' + this.getCoverageFileName() + COVERAGE_EXT;
    }

    public boolean isMergeWithPreviousResults() {
        return this.myIsMergeWithPreviousResults;
    }

    public void setMergeWithPreviousResults(boolean isMergeWithPreviousResults) {
        this.myIsMergeWithPreviousResults = isMergeWithPreviousResults;
    }
}

