/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PackageChooser;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.peer.PeerFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoverageConfigurable<T extends CoverageEnabledConfiguration>
extends SettingsEditor<T> {
    Project myProject;
    private MyClassFilterEditor myClassFilterEditor;
    private JCheckBox myCoverageEnabledCheckbox;
    private JCheckBox myMergeDataCheckbox;
    private JLabel myCoverageNotSupportedLabel;

    public CoverageConfigurable(Project project) {
        this.myProject = project;
    }

    protected abstract boolean isJre50Configured(T var1);

    @Override
    protected void resetEditorFrom(T configuration) {
        boolean isJre50 = this.isJre50Configured(configuration);
        this.myCoverageNotSupportedLabel.setVisible(!isJre50);
        this.myCoverageEnabledCheckbox.setEnabled(isJre50);
        this.myMergeDataCheckbox.setEnabled(isJre50);
        this.myMergeDataCheckbox.setSelected(((CoverageEnabledConfiguration)configuration).isMergeWithPreviousResults());
        this.myClassFilterEditor.setEnabled(isJre50);
        this.myCoverageEnabledCheckbox.setSelected(isJre50 && ((CoverageEnabledConfiguration)configuration).isCoverageEnabled());
        String[] filter = ((CoverageEnabledConfiguration)configuration).getCoveragePatterns();
        if (filter != null) {
            List<String> oldPatterns = Arrays.asList(this.myClassFilterEditor.getFilterPatterns());
            for (String pattern : filter) {
                if (oldPatterns.contains(pattern)) continue;
                this.myClassFilterEditor.addPattern(pattern);
            }
        }
    }

    @Override
    protected void applyEditorTo(T configuration) throws ConfigurationException {
        ((CoverageEnabledConfiguration)configuration).setCoverageEnabled(this.myCoverageEnabledCheckbox.isSelected());
        ((CoverageEnabledConfiguration)configuration).setMergeWithPreviousResults(this.myMergeDataCheckbox.isSelected());
        ((CoverageEnabledConfiguration)configuration).setCoveragePatterns(this.myClassFilterEditor.getFilterPatterns());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel(new VerticalFlowLayout());
        this.myCoverageEnabledCheckbox = new JCheckBox(ExecutionBundle.message("enable.coverage.with.emma", new Object[0]));
        result.add(this.myCoverageEnabledCheckbox);
        this.myMergeDataCheckbox = new JCheckBox(ExecutionBundle.message("merge.coverage.data", new Object[0]));
        result.add(this.myMergeDataCheckbox);
        JPanel panel = new JPanel(new VerticalFlowLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder(ExecutionBundle.message("record.coverage.filters.title", new Object[0])));
        this.myClassFilterEditor = new MyClassFilterEditor(this.myProject);
        panel.add(this.myClassFilterEditor);
        result.add(panel);
        this.myCoverageEnabledCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CoverageConfigurable.this.myClassFilterEditor.setEnabled(CoverageConfigurable.this.myCoverageEnabledCheckbox.isSelected());
            }
        });
        this.myCoverageNotSupportedLabel = new JLabel(CodeInsightBundle.message("code.coverage.is.not.supported", new Object[0]));
        this.myCoverageNotSupportedLabel.setIcon(UIUtil.getOptionPanelWarningIcon());
        result.add(this.myCoverageNotSupportedLabel);
        JPanel jPanel = result;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/coverage/CoverageConfigurable.createEditor must not return null");
        }
        return jPanel;
    }

    @Override
    protected void disposeEditor() {
    }

    private static class MyClassFilterEditor
    extends ClassFilterEditor {
        public MyClassFilterEditor(Project project) {
            super(project);
        }

        public String[] getFilterPatterns() {
            ClassFilter[] classFilters = super.getFilters();
            String[] result = new String[classFilters.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = classFilters[i].getPattern();
            }
            return result;
        }

        protected void addPatternFilter() {
            PackageChooser chooser = PeerFactory.getInstance().getUIHelper().createPackageChooser(CodeInsightBundle.message("coverage.pattern.filter.editor.choose.package.title", new Object[0]), this.myProject);
            chooser.show();
            List<PsiPackage> packages = chooser.getSelectedPackages();
            if (!packages.isEmpty()) {
                for (PsiPackage aPackage : packages) {
                    String fqName = aPackage.getQualifiedName();
                    String pattern = fqName.length() > 0 ? fqName + ".*" : "*";
                    this.myTableModel.addRow(this.createFilter(pattern));
                }
                int row = this.myTableModel.getRowCount() - 1;
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
                this.myTable.requestFocus();
            }
        }

        protected String getAddPatternButtonText() {
            return CodeInsightBundle.message("coverage.button.add.package", new Object[0]);
        }
    }
}

