/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConfigurationModule
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.configurations.RunConfigurationModule");
    @NonNls
    private static final String ELEMENT = "module";
    @NonNls
    private static final String ATTRIBUTE = "name";
    private Module myModule = null;
    private String myModuleName;
    private final Project myProject;
    private final boolean myClassesInLibraries;

    public RunConfigurationModule(Project project, boolean classesInLibs) {
        this.myProject = project;
        this.myClassesInLibraries = classesInLibs;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        Element module;
        String moduleName;
        List modules = element.getChildren(ELEMENT);
        LOG.assertTrue(modules.size() <= 1);
        if (modules.size() == 1 && (moduleName = (module = (Element)modules.get(0)).getAttributeValue(ATTRIBUTE)) != null && moduleName.length() > 0) {
            this.myModuleName = moduleName;
        }
    }

    @Override
    public void writeExternal(Element parent) throws WriteExternalException {
        Element element = new Element(ELEMENT);
        element.setAttribute(ATTRIBUTE, this.getModuleName());
        parent.addContent(element);
    }

    public void init() {
        if (this.getModuleName().trim().length() > 0) {
            return;
        }
        Module[] modules = this.getModuleManager().getModules();
        if (modules.length > 0) {
            this.setModule(modules[0]);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Module getModule() {
        if (this.myModuleName != null) {
            this.myModule = this.findModule(this.myModuleName);
            if (this.myModule != null) {
                this.myModuleName = null;
            }
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModuleName = this.myModule.getName();
            this.myModule = null;
        }
        return this.myModule;
    }

    @Nullable
    public Module findModule(String moduleName) {
        return this.getModuleManager().findModuleByName(moduleName);
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myModuleName = null;
    }

    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : "";
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    @Nullable
    public PsiClass findClass(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        Module module = this.getModule();
        GlobalSearchScope scope = module != null ? (this.myClassesInLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module) : GlobalSearchScope.moduleWithDependenciesScope(module)) : (this.myClassesInLibraries ? GlobalSearchScope.allScope(this.myProject) : GlobalSearchScope.projectScope(this.myProject));
        return PsiManager.getInstance(this.myProject).findClass(qualifiedName.replace('$', '.'), scope);
    }

    public static Collection<Module> getModulesForClass(@NotNull Project project, String className) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/RunConfigurationModule.getModulesForClass must not be null");
        }
        if (project.isDefault()) {
            return Arrays.asList(ModuleManager.getInstance(project).getModules());
        }
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        PsiClass[] possibleClasses = PsiManager.getInstance(project).findClasses(className, GlobalSearchScope.projectScope(project));
        THashSet modules = new THashSet();
        for (PsiClass aClass : possibleClasses) {
            Module module = ModuleUtil.findModuleForPsiElement(aClass);
            if (module == null) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return Arrays.asList(ModuleManager.getInstance(project).getModules());
        }
        return ModuleUtil.collectModulesDependsOn((Collection<Module>)modules);
    }

    public void checkForWarning() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module != null) {
            if (ModuleRootManager.getInstance(module).getJdk() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message("no.jdk.specified.for.module.warning.text", module.getName()));
            }
        } else {
            if (this.myModuleName != null) {
                throw new RuntimeConfigurationError(ExecutionBundle.message("module.doesn.t.exist.in.project.error.text", this.myModuleName));
            }
            throw new RuntimeConfigurationError(ExecutionBundle.message("module.not.specified.error.text", new Object[0]));
        }
    }

    public PsiClass checkClassName(String className, String errorMessage) throws RuntimeConfigurationException {
        if (className == null || className.length() == 0) {
            throw new RuntimeConfigurationError(errorMessage);
        }
        return this.findNotNullClass(className);
    }

    public PsiClass findNotNullClass(String className) throws RuntimeConfigurationWarning {
        PsiClass psiClass = this.findClass(className);
        if (psiClass == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message("class.not.found.in.module.error.message", className, this.getModuleName()));
        }
        return psiClass;
    }

    public PsiClass checkModuleAndClassName(String className, String expectedClassMessage) throws RuntimeConfigurationException {
        this.checkForWarning();
        return this.checkClassName(className, expectedClassMessage);
    }
}

