/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersList
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.configurations.ParametersList");
    private List<String> myParameters = new ArrayList<String>();
    private Map<String, String> myMacroMap = null;

    public boolean hasParameter(@NonNls String param) {
        return this.myParameters.contains(param);
    }

    public boolean hasProperty(@NonNls String name) {
        for (String parameter : this.myParameters) {
            if (!parameter.startsWith("-D" + name + "=")) continue;
            return true;
        }
        return false;
    }

    public String getParametersString() {
        StringBuffer buffer = new StringBuffer();
        String separator = " ";
        for (String param : this.myParameters) {
            buffer.append(" ");
            buffer.append(GeneralCommandLine.quote(param));
        }
        return buffer.toString();
    }

    public String[] getArray() {
        return this.myParameters.toArray(new String[this.myParameters.size()]);
    }

    public void addParametersString(String parameters) {
        if (parameters != null) {
            String[] parms;
            for (String parm : parms = ParametersList.parse(parameters)) {
                this.add(parm);
            }
        }
    }

    public void add(@NonNls String parameter) {
        this.myParameters.add(this.expandMacros(parameter));
    }

    public void addAt(int index, String parameter) {
        LOG.assertTrue(parameter != null);
        this.myParameters.add(index, this.expandMacros(parameter));
    }

    public void defineProperty(@NonNls String propertyName, @NonNls String propertyValue) {
        this.myParameters.add("-D" + propertyName + "=" + propertyValue);
    }

    public void replaceOrAppend(String parameterPrefix, String replacement) {
        this.replaceOrAdd(parameterPrefix, replacement, this.myParameters.size());
    }

    private void replaceOrAdd(String parameterPrefix, String replacement, int position) {
        ListIterator<String> iterator = this.myParameters.listIterator();
        while (iterator.hasNext()) {
            String param = iterator.next();
            if (!param.startsWith(parameterPrefix)) continue;
            if ("".equals(replacement)) {
                iterator.remove();
            } else {
                iterator.set(replacement);
            }
            return;
        }
        if (!"".equals(replacement)) {
            this.myParameters.add(position, replacement);
        }
    }

    public void replaceOrPrepend(String parameter, String replacement) {
        this.replaceOrAdd(parameter, replacement, 0);
    }

    public List<String> getList() {
        return Collections.unmodifiableList(this.myParameters);
    }

    public void prepend(@NonNls String parameter) {
        this.addAt(0, parameter);
    }

    public void add(@NonNls String name, @NonNls String value) {
        this.add(name);
        this.add(value);
    }

    public void addAll(String[] parameters) {
        this.myParameters.addAll(Arrays.asList(parameters));
    }

    public void addAll(List<String> parameters) {
        this.myParameters.addAll(parameters);
    }

    public ParametersList clone() {
        try {
            ParametersList clone = (ParametersList)super.clone();
            clone.myParameters = new ArrayList<String>(this.myParameters);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error(e);
            return null;
        }
    }

    public static String[] parse(String string) {
        return new ParametersTokenizer(string).execute();
    }

    public String expandMacros(String text) {
        Map<String, String> macroMap = this.getMacroMap();
        Set<String> set = macroMap.keySet();
        for (String from : set) {
            String to = macroMap.get(from);
            text = StringUtil.replace(text, from, to, true);
        }
        return text;
    }

    private Map<String, String> getMacroMap() {
        if (this.myMacroMap == null) {
            this.myMacroMap = new LinkedHashMap<String, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                application.runReadAction(new Runnable(){

                    public void run() {
                        PathMacros pathMacros = PathMacros.getInstance();
                        Set<String> names = pathMacros.getAllMacroNames();
                        for (String name : names) {
                            ParametersList.this.myMacroMap.put("${" + name + "}", pathMacros.getValue(name));
                        }
                    }
                });
                Map<String, String> env = EnvironmentUtil.getEnviromentProperties();
                for (String name : env.keySet()) {
                    String key = "${" + name + "}";
                    if (this.myMacroMap.containsKey(key)) continue;
                    this.myMacroMap.put(key, env.get(name));
                }
            }
        }
        return this.myMacroMap;
    }

    private static class ParametersTokenizer {
        private final String myParamsString;
        private final List<String> myArray = new ArrayList<String>();
        private final StringBuffer myBuffer = new StringBuffer(128);
        private boolean myTokenStarted = false;
        private boolean myUnquotedSlash = false;

        public ParametersTokenizer(String parmsString) {
            this.myParamsString = parmsString;
        }

        public String[] execute() {
            boolean inQuotes = false;
            boolean wasEscaped = false;
            for (int i = 0; i < this.myParamsString.length(); ++i) {
                char c = this.myParamsString.charAt(i);
                if (inQuotes) {
                    LOG.assertTrue(!this.myUnquotedSlash);
                    if (wasEscaped) {
                        this.append(c);
                        wasEscaped = false;
                        continue;
                    }
                    if (c == '\"') {
                        inQuotes = false;
                        continue;
                    }
                    if (c == '\\') {
                        this.myTokenStarted = true;
                        this.append(c);
                        wasEscaped = true;
                        continue;
                    }
                    this.append(c);
                    continue;
                }
                inQuotes = this.processNotQuoted(c);
            }
            this.tokenFinished();
            return this.myArray.toArray(new String[this.myArray.size()]);
        }

        private boolean processNotQuoted(char c) {
            if (c == '\"') {
                if (this.myUnquotedSlash) {
                    this.append(c);
                    this.myUnquotedSlash = false;
                    return false;
                }
                this.myTokenStarted = true;
                return true;
            }
            if (c == ' ') {
                this.tokenFinished();
            } else {
                if (c == '\\') {
                    this.myUnquotedSlash = true;
                    this.append(c);
                    return false;
                }
                this.append(c);
            }
            this.myUnquotedSlash = false;
            return false;
        }

        private void append(char nextChar) {
            this.myBuffer.append(nextChar);
            this.myTokenStarted = true;
        }

        private void tokenFinished() {
            if (this.myTokenStarted) {
                String token = this.myBuffer.length() == 0 ? "\"\"" : this.myBuffer.toString();
                this.myArray.add(token);
            }
            this.myBuffer.setLength(0);
            this.myTokenStarted = false;
        }
    }
}

