/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleBasedConfiguration
extends RuntimeConfiguration {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.configurations.ModuleBasedConfiguration");
    private final RunConfigurationModule myModule;
    @NonNls
    protected static final String TO_CLONE_ELEMENT_NAME = "toClone";

    public ModuleBasedConfiguration(String name, RunConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(name, configurationModule.getProject(), factory);
        this.myModule = configurationModule;
    }

    public abstract Collection<Module> getValidModules();

    public RunConfigurationModule getConfigurationModule() {
        return this.myModule;
    }

    public void init() {
        this.myModule.init();
    }

    public void setModule(Module module) {
        if (module == null) {
            return;
        }
        this.myModule.setModule(module);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
    }

    protected void readModule(Element element) throws InvalidDataException {
        this.myModule.readExternal(element);
    }

    protected void writeModule(Element element) throws WriteExternalException {
        this.myModule.writeExternal(element);
    }

    public Collection<Module> getAllModules() {
        return Arrays.asList(ModuleManager.getInstance(this.getProject()).getModules());
    }

    protected abstract ModuleBasedConfiguration createInstance();

    @Override
    public ModuleBasedConfiguration clone() {
        Element element = new Element(TO_CLONE_ELEMENT_NAME);
        try {
            this.writeExternal(element);
            ModuleBasedConfiguration configuration = this.createInstance();
            configuration.init();
            configuration.readExternal(element);
            return configuration;
        }
        catch (InvalidDataException e) {
            LOG.error(e);
            return null;
        }
        catch (WriteExternalException e) {
            LOG.error(e);
            return null;
        }
    }

    @Override
    public Module[] getModules() {
        return ApplicationManager.getApplication().runReadAction(new Computable<Module[]>(){

            @Override
            public Module[] compute() {
                Module[] moduleArray;
                Module module = ModuleBasedConfiguration.this.getConfigurationModule().getModule();
                if (module == null) {
                    moduleArray = null;
                } else {
                    Module[] moduleArray2 = new Module[1];
                    moduleArray = moduleArray2;
                    moduleArray2[0] = module;
                }
                return moduleArray;
            }
        });
    }
}

