/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaParameters {
    private ProjectJdk myJdk;
    private final PathsList myClassPath = new PathsList();
    private String myMainClass;
    private final ParametersList myVmParameters = new ParametersList();
    private final ParametersList myProgramParameters = new ParametersList();
    private String myWorkingDirectory;
    private Charset myCharset = CharsetToolkit.getIDEOptionsCharset();
    private Map<String, String> myEnv;
    private boolean myPassParentEnvs = true;
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    private static final int TESTS_ONLY = 4;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public String getMainClass() {
        return this.myMainClass;
    }

    @Nullable
    public ProjectJdk getJdk() {
        return this.myJdk;
    }

    public String getJdkPath() throws CantRunException {
        ProjectJdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message("no.jdk.specified..error.message", new Object[0]));
        }
        String jdkHome = jdk.getHomeDirectory().getPresentableUrl();
        if (jdkHome == null || jdkHome.length() == 0) {
            throw new CantRunException(ExecutionBundle.message("home.directory.not.specified.for.jdk.error.message", new Object[0]));
        }
        return jdkHome;
    }

    public void setJdk(ProjectJdk jdk) {
        this.myJdk = jdk;
    }

    public void setMainClass(@NonNls String mainClass) {
        this.myMainClass = mainClass;
    }

    public void setWorkingDirectory(File path) {
        this.setWorkingDirectory(path.getPath());
    }

    public void setWorkingDirectory(@NonNls String path) {
        this.myWorkingDirectory = path;
    }

    public void configureByModule(Module module, int classPathType, ProjectJdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.myJdk = jdk;
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        ProjectRootsTraversing.collectRoots(module, (classPathType & 4) != 0 ? ProjectRootsTraversing.FULL_CLASSPATH_RECURSIVE : ProjectRootsTraversing.FULL_CLASSPATH_WITHOUT_TESTS, this.myClassPath);
    }

    public void configureByModule(Module module, int classPathType) throws CantRunException {
        this.configureByModule(module, classPathType, JavaParameters.getModuleJdk(module));
    }

    public static ProjectJdk getModuleJdk(Module module) throws CantRunException {
        ProjectJdk jdk = ModuleRootManager.getInstance(module).getJdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule(module);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured(jdk, module);
        }
        return jdk;
    }

    public void configureByProject(Project project, int classPathType, ProjectJdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.myJdk = jdk;
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        ProjectRootsTraversing.collectRoots(project, (classPathType & 4) != 0 ? ProjectRootsTraversing.FULL_CLASSPATH_RECURSIVE : ProjectRootsTraversing.FULL_CLASSPATH_WITHOUT_TESTS, this.myClassPath);
    }

    public ParametersList getVMParametersList() {
        return this.myVmParameters;
    }

    public ParametersList getProgramParametersList() {
        return this.myProgramParameters;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public PathsList getClassPath() {
        return this.myClassPath;
    }

    public Map<String, String> getEnv() {
        return this.myEnv;
    }

    public void setEnv(Map<String, String> env) {
        this.myEnv = env;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passDefaultEnvs) {
        this.myPassParentEnvs = passDefaultEnvs;
    }
}

