/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnableState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.DefaultJavaProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.IconLoader;

public abstract class CommandLineState
implements RunnableState {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.configurations.CommandLineState");
    private TextConsoleBuilder myConsoleBuilder;
    private Module[] myModulesToCompile = Module.EMPTY_ARRAY;
    private RunnerSettings myRunnerSettings;
    private ConfigurationPerRunnerSettings myConfigurationSettings;

    protected CommandLineState(RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
    }

    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    public ExecutionResult execute() throws ExecutionException {
        ConsoleView console;
        OSProcessHandler processHandler = this.startProcess();
        TextConsoleBuilder builder = this.getConsoleBuilder();
        ConsoleView consoleView = console = builder != null ? builder.getConsole() : null;
        if (console != null) {
            console.attachToProcess(processHandler);
        }
        return new DefaultExecutionResult(console, processHandler, this.createActions(console, processHandler));
    }

    protected OSProcessHandler startProcess() throws ExecutionException {
        DefaultJavaProcessHandler processHandler = new DefaultJavaProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach(processHandler);
        return processHandler;
    }

    protected abstract GeneralCommandLine createCommandLine() throws ExecutionException;

    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler) {
        if (console == null || !console.canPause()) {
            return new AnAction[0];
        }
        return new AnAction[]{new PauseOutputAction(console, processHandler)};
    }

    protected TextConsoleBuilder getConsoleBuilder() {
        return this.myConsoleBuilder;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        this.myConsoleBuilder = consoleBuilder;
    }

    public Module[] getModulesToCompile() {
        return this.myModulesToCompile;
    }

    public void setModulesToCompile(Module[] modulesToCompile) {
        if (modulesToCompile == null) {
            modulesToCompile = Module.EMPTY_ARRAY;
        }
        for (Module module : modulesToCompile) {
            LOG.assertTrue(module != null);
        }
        this.myModulesToCompile = modulesToCompile;
    }

    public void setModuleToCompile(Module module) {
        if (module == null) {
            return;
        }
        this.setModulesToCompile(new Module[]{module});
    }

    protected static class PauseOutputAction
    extends ToggleAction {
        private final ConsoleView myConsole;
        private final ProcessHandler myProcessHandler;

        public PauseOutputAction(ConsoleView console, ProcessHandler processHandler) {
            super(ExecutionBundle.message("run.configuration.pause.output.action.name", new Object[0]), null, IconLoader.getIcon("/actions/pause.png"));
            this.myConsole = console;
            this.myProcessHandler = processHandler;
        }

        public boolean isSelected(AnActionEvent event) {
            return this.myConsole.isOutputPaused();
        }

        public void setSelected(final AnActionEvent event, boolean flag) {
            this.myConsole.setOutputPaused(flag);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                public void run() {
                    PauseOutputAction.this.update(event);
                }
            });
        }

        public void update(final AnActionEvent event) {
            boolean isRunning;
            super.update(event);
            Presentation presentation = event.getPresentation();
            boolean bl = isRunning = this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation.setEnabled(true);
            } else {
                if (!this.myConsole.canPause()) {
                    presentation.setEnabled(false);
                    return;
                }
                if (!this.myConsole.hasDeferredOutput()) {
                    presentation.setEnabled(false);
                } else {
                    presentation.setEnabled(true);
                    this.myConsole.performWhenNoDeferredOutput(new Runnable(){

                        public void run() {
                            PauseOutputAction.this.update(event);
                        }
                    });
                }
            }
        }
    }
}

