/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiLocation<E extends PsiElement>
extends Location<E> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.PsiLocation");
    private final E myPsiElement;
    private final Project myProject;

    public PsiLocation(@NotNull Project project, @NotNull E psiElement) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/PsiLocation.<init> must not be null");
        }
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/PsiLocation.<init> must not be null");
        }
        this.myPsiElement = psiElement;
        this.myProject = project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public E getPsiElement() {
        E e = this.myPsiElement;
        if (e == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/PsiLocation.getPsiElement must not return null");
        }
        return e;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/PsiLocation.getProject must not return null");
        }
        return project;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> ancestorClass, boolean strict) {
        void var3_5;
        if (!strict && ancestorClass.isInstance(this.myPsiElement)) {
            E e = this.myPsiElement;
        } else {
            T t = PsiLocation.findNext(this.myPsiElement, ancestorClass);
        }
        Iterator iterator = new Iterator<Location<T>>((PsiElement)var3_5, ancestorClass){
            private T myCurrent;
            final /* synthetic */ PsiElement val$first;
            final /* synthetic */ Class val$ancestorClass;
            {
                this.val$first = psiElement;
                this.val$ancestorClass = clazz;
                this.myCurrent = this.val$first;
            }

            @Override
            public boolean hasNext() {
                return this.myCurrent != null;
            }

            @Override
            public Location<T> next() {
                if (this.myCurrent == null) {
                    throw new NoSuchElementException();
                }
                PsiLocation psiLocation = new PsiLocation(PsiLocation.this.myProject, this.myCurrent);
                this.myCurrent = PsiLocation.findNext(this.myCurrent, this.val$ancestorClass);
                return psiLocation;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
        if (iterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/PsiLocation.getAncestors must not return null");
        }
        return iterator;
    }

    @Override
    public PsiLocation<E> toPsiLocation() {
        return this;
    }

    private static <ElementClass extends PsiElement> ElementClass findNext(PsiElement psiElement, Class<ElementClass> ancestorClass) {
        PsiElement element = psiElement;
        while ((element = element.getParent()) != null && !(element instanceof PsiFile)) {
            PsiElement ancestor = (PsiElement)PsiLocation.safeCast(element, ancestorClass);
            if (ancestor == null) continue;
            return (ElementClass)ancestor;
        }
        return null;
    }

    public static Location<PsiClass> fromClassQualifiedName(Project project, String qualifiedName) {
        PsiClass psiClass = PsiManager.getInstance(project).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.allScope(project));
        return psiClass != null ? new PsiLocation<PsiClass>(project, psiClass) : null;
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(Project project, T element) {
        if (element == null) {
            return null;
        }
        return new PsiLocation<T>(project, element);
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(T element) {
        if (element == null) {
            return null;
        }
        if (!element.isValid()) {
            return null;
        }
        return new PsiLocation<T>(element.getProject(), element);
    }
}

