/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Location<E extends PsiElement> {
    @NonNls
    public static final String LOCATION = "Location";

    @NotNull
    public abstract E getPsiElement();

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> var1, boolean var2);

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        E psiElement = this.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.getProject(), virtualFile, psiElement.getTextOffset());
    }

    public <Ancestor extends PsiElement> Location<Ancestor> getParent(Class<Ancestor> parentClass) {
        Iterator<Location<PsiElement>> ancestors = this.getAncestors(PsiElement.class, true);
        if (!ancestors.hasNext()) {
            return null;
        }
        Location<PsiElement> parent = ancestors.next();
        if (parentClass.isInstance(parent.getPsiElement())) {
            return parent;
        }
        return null;
    }

    public <T extends PsiElement> Location<T> getAncestorOrSelf(Class<T> ancestorClass) {
        Iterator<Location<T>> ancestors = this.getAncestors(ancestorClass, false);
        if (!ancestors.hasNext()) {
            return null;
        }
        return ancestors.next();
    }

    public <Ancestor extends PsiElement> Ancestor getParentElement(Class<Ancestor> parentClass) {
        return Location.safeGetPsiElement(this.getParent(parentClass));
    }

    public static <T extends PsiElement> T safeGetPsiElement(Location<T> location) {
        return location != null ? (T)location.getPsiElement() : null;
    }

    public static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    public PsiLocation<E> toPsiLocation() {
        return new PsiLocation<E>(this.getProject(), this.getPsiElement());
    }
}

