/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.Element;

public class LogFilter
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.diagnostic.logging.LogFilter");
    public String myName;
    public String myIconPath;
    private Icon myIcon;

    public LogFilter(String name, Icon icon) {
        this.myName = name;
        this.myIcon = icon;
    }

    public LogFilter(String name, String iconPath) {
        this.myName = name;
        this.myIconPath = iconPath;
    }

    public LogFilter() {
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public boolean isAcceptable(String line) {
        return true;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        if (this.myIconPath != null && new File(FileUtil.toSystemDependentName(this.myIconPath)).exists()) {
            Image image = null;
            try {
                image = ImageLoader.loadFromStream(VfsUtil.convertToURL(VfsUtil.pathToUrl(this.myIconPath)).openStream());
            }
            catch (IOException e) {
                LOG.debug(e);
            }
            if (image != null) {
                return IconLoader.getIcon(image);
            }
        }
        return IconLoader.getIcon("/ant/filter.png");
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
    }
}

