/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class DebuggerUtils
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.debugger.engine.DebuggerUtils");
    private static final Key<Method> TO_STRING_METHOD_KEY = new Key("CachedToStringMethod");

    @NonNls
    public static String getValueAsString(EvaluationContext evaluationContext, Value value) throws EvaluateException {
        try {
            if (value == null) {
                return "null";
            }
            if (value instanceof StringReference) {
                return ((StringReference)value).value();
            }
            if (DebuggerUtils.isInteger(value)) {
                long v = ((PrimitiveValue)value).longValue();
                return String.valueOf(v);
            }
            if (DebuggerUtils.isNumeric(value)) {
                double v = ((PrimitiveValue)value).doubleValue();
                return String.valueOf(v);
            }
            if (value instanceof BooleanValue) {
                boolean v = ((PrimitiveValue)value).booleanValue();
                return String.valueOf(v);
            }
            if (value instanceof CharValue) {
                char v = ((PrimitiveValue)value).charValue();
                return String.valueOf(v);
            }
            if (value instanceof ObjectReference) {
                ObjectReference objRef = (ObjectReference)value;
                DebugProcess debugProcess = evaluationContext.getDebugProcess();
                Method toStringMethod = debugProcess.getUserData(TO_STRING_METHOD_KEY);
                if (toStringMethod == null) {
                    try {
                        ReferenceType refType = objRef.virtualMachine().classesByName("java.lang.Object").get(0);
                        toStringMethod = DebuggerUtils.findMethod(refType, "toString", "()Ljava/lang/String;");
                        debugProcess.putUserData(TO_STRING_METHOD_KEY, toStringMethod);
                    }
                    catch (Exception e) {
                        throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.cannot.evaluate.tostring", objRef.referenceType().name()));
                    }
                }
                if (toStringMethod == null) {
                    throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.cannot.evaluate.tostring", objRef.referenceType().name()));
                }
                StringReference stringReference = (StringReference)debugProcess.invokeInstanceMethod(evaluationContext, objRef, toStringMethod, Collections.emptyList(), 1);
                return stringReference == null ? "null" : stringReference.value();
            }
            throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.unsupported.expression.type", new Object[0]));
        }
        catch (ObjectCollectedException e) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    public static Method findMethod(ReferenceType refType, @NonNls String methodName, @NonNls String methodSignature) {
        Method method = null;
        if (methodSignature != null) {
            List<Method> methods;
            if (refType instanceof ClassType) {
                method = ((ClassType)refType).concreteMethodByName(methodName, methodSignature);
            }
            if (method == null && (methods = refType.methodsByName(methodName, methodSignature)).size() > 0) {
                method = methods.get(0);
            }
        } else {
            List<Method> methods = null;
            if (refType instanceof ClassType) {
                methods = refType.methodsByName(methodName);
            }
            if (methods != null && methods.size() == 0) {
                methods = refType.methodsByName(methodName);
            }
            if (methods != null && methods.size() > 0) {
                method = methods.get(0);
            }
        }
        return method;
    }

    public static boolean isNumeric(Value value) {
        return value != null && (DebuggerUtils.isInteger(value) || value instanceof FloatValue || value instanceof DoubleValue);
    }

    public static boolean isInteger(Value value) {
        return value != null && (value instanceof ByteValue || value instanceof ShortValue || value instanceof LongValue || value instanceof IntegerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translateStringValue(String str) {
        int length = str.length();
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            StringUtil.escapeStringCharacters(length, str, buffer);
            if (str.length() > length) {
                buffer.append("...");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(buffer);
        }
    }

    protected static ArrayClass getArrayClass(String className) {
        int pos;
        boolean searchBracket = false;
        int dims = 0;
        for (pos = className.lastIndexOf(93); pos >= 0; --pos) {
            char c = className.charAt(pos);
            if (searchBracket) {
                if (c == '[') {
                    ++dims;
                    searchBracket = false;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                break;
            }
            if (c == ']') {
                searchBracket = true;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (searchBracket) {
            return null;
        }
        if (dims == 0) {
            return null;
        }
        return new ArrayClass(className.substring(0, pos + 1), dims);
    }

    public static boolean instanceOf(String subType, String superType, Project project) {
        if (project == null) {
            return subType.equals(superType);
        }
        ArrayClass nodeClass = DebuggerUtils.getArrayClass(subType);
        ArrayClass rendererClass = DebuggerUtils.getArrayClass(superType);
        if (nodeClass == null || rendererClass == null) {
            return false;
        }
        if (nodeClass.dims == rendererClass.dims) {
            GlobalSearchScope scope = GlobalSearchScope.allScope(project);
            PsiClass psiNodeClass = PsiManager.getInstance(project).findClass(nodeClass.className, scope);
            PsiClass psiRendererClass = PsiManager.getInstance(project).findClass(rendererClass.className, scope);
            return InheritanceUtil.isInheritorOrSelf(psiNodeClass, psiRendererClass, true);
        }
        if (nodeClass.dims > rendererClass.dims) {
            return rendererClass.className.equals("java.lang.Object");
        }
        return false;
    }

    public static Type getSuperType(Type subType, String superType) {
        if ("java.lang.Object".equals(superType)) {
            List<ReferenceType> list = subType.virtualMachine().classesByName("java.lang.Object");
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        return DebuggerUtils.getSuperTypeInt(subType, superType);
    }

    private static Type getSuperTypeInt(Type subType, String superType) {
        List<ReferenceType> list;
        if (subType == null) {
            return null;
        }
        if (subType.name().equals(superType)) {
            return subType;
        }
        if (subType instanceof ClassType) {
            Type result = DebuggerUtils.getSuperType(((ClassType)subType).superclass(), superType);
            if (result != null) {
                return result;
            }
            List<InterfaceType> ifaces = ((ClassType)subType).allInterfaces();
            for (InterfaceType interfaceType : ifaces) {
                if (!interfaceType.name().equals(superType)) continue;
                return interfaceType;
            }
            return null;
        }
        if (subType instanceof InterfaceType) {
            List<InterfaceType> ifaces = ((InterfaceType)subType).superinterfaces();
            for (InterfaceType interfaceType : ifaces) {
                Type result = DebuggerUtils.getSuperType(interfaceType, superType);
                if (result == null) continue;
                return result;
            }
        } else if (subType instanceof ArrayType) {
            if (superType.endsWith("[]")) {
                try {
                    String superTypeItem = superType.substring(0, superType.length() - 2);
                    Type subTypeItem = ((ArrayType)subType).componentType();
                    return DebuggerUtils.instanceOf(subTypeItem, superTypeItem) ? subType : null;
                }
                catch (ClassNotLoadedException e) {
                    LOG.debug(e);
                }
            }
        } else if (subType instanceof PrimitiveType && superType.equals("java.lang.Primitive")) {
            return subType;
        }
        if ("java.lang.Object".equals(superType) && (list = subType.virtualMachine().classesByName("java.lang.Object")).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static boolean instanceOf(Type subType, String superType) {
        return DebuggerUtils.getSuperType(subType, superType) != null;
    }

    public static PsiClass findClass(String className, Project project, GlobalSearchScope scope) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(project);
        if (DebuggerUtils.getArrayClass(className) != null) {
            return psiManager.getElementFactory().getArrayClass(psiManager.getEffectiveLanguageLevel());
        }
        if (project.isDefault()) {
            return null;
        }
        String _className = className.replace('$', '.');
        PsiClass aClass = psiManager.findClass(_className, scope);
        if (aClass == null && scope != GlobalSearchScope.allScope(project)) {
            return psiManager.findClass(_className, GlobalSearchScope.allScope(project));
        }
        return aClass;
    }

    public static PsiType getType(String className, Project project) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(project);
        try {
            if (DebuggerUtils.getArrayClass(className) != null) {
                return psiManager.getElementFactory().createTypeFromText(className, null);
            }
            if (project.isDefault()) {
                return null;
            }
            PsiClass aClass = psiManager.findClass(className.replace('$', '.'), GlobalSearchScope.allScope(project));
            return psiManager.getElementFactory().createType(aClass);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    public static void checkSyntax(PsiCodeFragment codeFragment) throws EvaluateException {
        PsiElement[] children = codeFragment.getChildren();
        if (children.length == 0) {
            throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.empty.code.fragment", new Object[0]));
        }
        for (int i = 0; i < children.length; ++i) {
            PsiElement child = children[i];
            if (!(child instanceof PsiErrorElement)) continue;
            throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.invalid.expression", child.getText()));
        }
    }

    public abstract String findAvailableDebugAddress(boolean var1) throws ExecutionException;

    public static boolean isSynthetic(TypeComponent typeComponent) {
        if (typeComponent == null) {
            return false;
        }
        VirtualMachine machine = typeComponent.virtualMachine();
        return machine != null && machine.canGetSyntheticAttribute() && typeComponent.isSynthetic();
    }

    public static boolean isSimpleGetter(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiExpression value = ((PsiReturnStatement)statement).getReturnValue();
        if (!(value instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier != null && !"this".equals(qualifier.getText())) {
            return false;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return false;
        }
        if (!(referent instanceof PsiField)) {
            return false;
        }
        return ((PsiField)referent).getContainingClass().equals(method.getContainingClass());
    }

    public static DebuggerUtils getInstance() {
        return ServiceManager.getService(DebuggerUtils.class);
    }

    public abstract PsiExpression substituteThis(PsiExpression var1, PsiExpression var2, Value var3, StackFrameContext var4) throws EvaluateException;

    public abstract DebuggerContext getDebuggerContext(DataContext var1);

    public abstract Element writeTextWithImports(TextWithImports var1);

    public abstract TextWithImports readTextWithImports(Element var1);

    public abstract void writeTextWithImports(Element var1, @NonNls String var2, TextWithImports var3);

    public abstract TextWithImports readTextWithImports(Element var1, @NonNls String var2);

    public abstract TextWithImports createExpressionWithImports(@NonNls String var1);

    public abstract PsiElement getContextElement(StackFrameContext var1);

    public abstract PsiClass chooseClassDialog(String var1, Project var2);

    public static boolean supportsJVMDebugging(FileType type) {
        return type instanceof LanguageFileType && ((LanguageFileType)type).isJVMDebuggingSupported();
    }

    protected static class ArrayClass {
        public String className;
        public int dims;

        public ArrayClass(String className, int dims) {
            this.className = className;
            this.dims = dims;
        }
    }
}

