/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SourcePosition
implements Navigatable {
    @NotNull
    public abstract PsiFile getFile();

    public abstract int getLine();

    public abstract int getOffset();

    public abstract Editor openEditor(boolean var1);

    public static SourcePosition createFromLine(final PsiFile file, final int line) {
        return new SourcePositionCache(file){

            protected int calcLine() {
                return line;
            }

            protected int calcOffset() {
                Document document = PsiDocumentManager.getInstance(file.getProject()).getDocument(file);
                if (document != null) {
                    try {
                        return document.getLineStartOffset(line);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                return -1;
            }
        };
    }

    public static SourcePosition createFromOffset(final PsiFile file, final int offset) {
        return new SourcePositionCache(file){

            protected int calcLine() {
                Document document = PsiDocumentManager.getInstance(file.getProject()).getDocument(file);
                if (document != null) {
                    try {
                        return document.getLineNumber(offset);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                return -1;
            }

            protected int calcOffset() {
                return offset;
            }
        };
    }

    public static SourcePosition createFromElement(PsiElement element) {
        PsiElement navigationElement = element.getNavigationElement();
        PsiFile psiFile = PsiUtil.isInJspFile(navigationElement) ? PsiUtil.getJspFile(navigationElement) : navigationElement.getContainingFile();
        return SourcePosition.createFromOffset(psiFile, navigationElement.getTextOffset());
    }

    public boolean equals(Object o) {
        if (o instanceof SourcePosition) {
            SourcePosition sourcePosition = (SourcePosition)o;
            return Comparing.equal(sourcePosition.getFile(), this.getFile()) && sourcePosition.getOffset() == this.getOffset();
        }
        return false;
    }

    private static abstract class SourcePositionCache
    extends SourcePosition {
        private static final Logger LOG = Logger.getInstance("#com.intellij.debugger.SourcePosition.SourcePositionCache");
        @NotNull
        private final PsiFile myFile;
        private long myModificationStamp = -1L;
        private int myLine;
        private int myOffset;

        public SourcePositionCache(PsiFile file) {
            LOG.assertTrue(file != null);
            this.myFile = file;
            this.updateData();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/debugger/SourcePosition$SourcePositionCache.getFile must not return null");
            }
            return psiFile;
        }

        public boolean canNavigate() {
            return this.getFile().isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public void navigate(final boolean requestFocus) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                public void run() {
                    if (!SourcePositionCache.this.canNavigate()) {
                        return;
                    }
                    SourcePositionCache.this.openEditor(requestFocus);
                }
            });
        }

        public Editor openEditor(boolean requestFocus) {
            PsiFile psiFile = this.getFile();
            Project project = psiFile.getProject();
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            int offset = this.getOffset();
            if (offset < 0) {
                return null;
            }
            return FileEditorManager.getInstance(project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), requestFocus);
        }

        private void updateData() {
            if (this.myModificationStamp != this.myFile.getModificationStamp()) {
                this.myModificationStamp = this.myFile.getModificationStamp();
                this.myLine = this.calcLine();
                this.myOffset = this.calcOffset();
            }
        }

        public int getLine() {
            this.updateData();
            return this.myLine;
        }

        public int getOffset() {
            this.updateData();
            return this.myOffset;
        }

        protected abstract int calcLine();

        protected abstract int calcOffset();
    }
}

