/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.Job;
import com.intellij.openapi.components.ServiceManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JobScheduler {
    private static final ScheduledExecutorService ourScheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new Thread(r, "Periodic tasks thread");
        }
    });

    public static JobScheduler getInstance() {
        return ServiceManager.getService(JobScheduler.class);
    }

    public abstract <T> Job<T> createJob(@NonNls String var1, int var2);

    public static ScheduledExecutorService getScheduler() {
        return ourScheduledExecutorService;
    }
}

