/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.taskdefs;

import com.intellij.compiler.ant.Tag;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public class ZipFileSet
extends Tag {
    public static final ZipFileSet[] EMPTY_ARRAY = new ZipFileSet[0];

    public ZipFileSet(@NonNls String fileOrDir, @NonNls String relativePath, boolean isDir) {
        super("zipfileset", new Pair[]{ZipFileSet.pair(isDir ? "dir" : "file", fileOrDir), ZipFileSet.pair("prefix", ZipFileSet.prefix(isDir, relativePath))});
    }

    private static String prefix(boolean isDir, String relativePath) {
        String parent;
        String path = isDir ? relativePath : ((parent = new File(relativePath).getParent()) == null ? "" : FileUtil.toSystemIndependentName(parent));
        return path == null ? null : StringUtil.trimStart(path, "/");
    }
}

