/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.taskdefs;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Tag;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Javac
extends Tag {
    public Javac(GenerationOptions genOptions, String moduleName, String outputDir) {
        super(genOptions.enableFormCompiler ? "javac2" : "javac", Javac.getAttributes(genOptions, outputDir, moduleName));
    }

    private static Pair[] getAttributes(GenerationOptions genOptions, String outputDir, String moduleName) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        pairs.add(Javac.pair("destdir", outputDir));
        pairs.add(Javac.pair("debug", BuildProperties.propertyRef("compiler.debug")));
        pairs.add(Javac.pair("nowarn", BuildProperties.propertyRef("compiler.generate.no.warnings")));
        pairs.add(Javac.pair("memorymaximumsize", BuildProperties.propertyRef("compiler.max.memory")));
        pairs.add(Javac.pair("fork", "true"));
        if (genOptions.forceTargetJdk) {
            pairs.add(Javac.pair("executable", Javac.getExecutable(moduleName)));
        }
        return pairs.toArray(new Pair[pairs.size()]);
    }

    @Nullable
    @NonNls
    private static String getExecutable(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        return BuildProperties.propertyRef(BuildProperties.getModuleChunkJdkBinProperty(moduleName)) + "/javac";
    }
}

