/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.openapi.util.Pair;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends CompositeGenerator {
    public static final Tag[] EMPTY_ARRAY = new Tag[0];
    private final String myTagName;
    private final Pair[] myTagOptions;

    public Tag(@NonNls String tagName, Pair[] tagOptions) {
        this.myTagName = tagName;
        this.myTagOptions = tagOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(DataOutput out) throws IOException {
        out.writeBytes("<");
        out.writeBytes(this.myTagName);
        if (this.myTagOptions != null && this.myTagOptions.length > 0) {
            out.writeBytes(" ");
            int generated = 0;
            for (Pair option : this.myTagOptions) {
                if (option == null) continue;
                if (generated > 0) {
                    out.writeBytes(" ");
                }
                out.writeBytes((String)option.getFirst());
                out.writeBytes("=\"");
                out.writeBytes((String)option.getSecond());
                out.writeBytes("\"");
                ++generated;
            }
        }
        if (this.getGeneratorCount() > 0) {
            out.writeBytes(">");
            Tag.shiftIndent();
            try {
                super.generate(out);
            }
            finally {
                Tag.unshiftIndent();
            }
            Tag.crlf(out);
            out.writeBytes("</");
            out.writeBytes(this.myTagName);
            out.writeBytes(">");
        } else {
            out.writeBytes("/>");
        }
    }

    protected static Pair<String, String> pair(@NonNls String v1, @NonNls String v2) {
        if (v2 == null) {
            return null;
        }
        return new Pair<String, String>(v1, v2);
    }
}

