/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.roots.ModuleRootManager;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class ModuleChunk {
    private final Module[] myModules;
    private Module myMainModule;
    private ModuleChunk[] myDependentChunks;
    private File myBaseDir = null;

    public ModuleChunk(Module[] modules) {
        this.myModules = modules;
        this.myMainModule = this.myModules[0];
    }

    public String getName() {
        return this.myMainModule.getName();
    }

    public Module[] getModules() {
        return this.myModules;
    }

    @Nullable
    public String getOutputDirUrl() {
        return ModuleRootManager.getInstance(this.myMainModule).getCompilerOutputPathUrl();
    }

    public String getTestsOutputDirUrl() {
        return ModuleRootManager.getInstance(this.myMainModule).getCompilerOutputPathForTestsUrl();
    }

    public boolean isSavePathsRelative() {
        return this.myMainModule.isSavePathsRelative();
    }

    public boolean isJdkInherited() {
        return ModuleRootManager.getInstance(this.myMainModule).isJdkInherited();
    }

    @Nullable
    public ProjectJdk getJdk() {
        return ModuleRootManager.getInstance(this.myMainModule).getJdk();
    }

    public ModuleChunk[] getDependentChunks() {
        return this.myDependentChunks;
    }

    public void setDependentChunks(ModuleChunk[] dependentChunks) {
        this.myDependentChunks = dependentChunks;
    }

    public File getBaseDir() {
        if (this.myBaseDir != null) {
            return this.myBaseDir;
        }
        return new File(this.myMainModule.getModuleFilePath()).getParentFile();
    }

    public void setBaseDir(File baseDir) {
        this.myBaseDir = baseDir;
    }

    public void setMainModule(Module module) {
        this.myMainModule = module;
    }

    public Project getProject() {
        return this.myMainModule.getProject();
    }
}

