/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class GenerationUtils {
    private GenerationUtils() {
    }

    public static String toRelativePath(VirtualFile file, ModuleChunk chunk, GenerationOptions genOptions) {
        Module module = chunk.getModules()[0];
        File moduleBaseDir = chunk.getBaseDir();
        return GenerationUtils.toRelativePath(file, moduleBaseDir, BuildProperties.getModuleBasedirProperty(module), genOptions, !chunk.isSavePathsRelative());
    }

    public static String toRelativePath(String file, File baseDir, Module module, GenerationOptions genOptions) {
        return GenerationUtils.toRelativePath(file, baseDir, BuildProperties.getModuleBasedirProperty(module), genOptions, !module.isSavePathsRelative());
    }

    public static String toRelativePath(String path, ModuleChunk chunk, GenerationOptions genOptions) {
        return GenerationUtils.toRelativePath(path, chunk.getBaseDir(), BuildProperties.getModuleChunkBasedirProperty(chunk), genOptions, !chunk.isSavePathsRelative());
    }

    public static String toRelativePath(VirtualFile file, File baseDir, String baseDirPropertyName, GenerationOptions genOptions, boolean useAbsolutePathsForOuterPaths) {
        return GenerationUtils.toRelativePath(PathUtil.getLocalPath(file), baseDir, baseDirPropertyName, genOptions, useAbsolutePathsForOuterPaths);
    }

    public static String toRelativePath(String path, File baseDir, @NonNls String baseDirPropertyName, GenerationOptions genOptions, boolean useAbsolutePathsForOuterPaths) {
        String substitutedPath = genOptions.subsitutePathWithMacros(path = path.replace(File.separatorChar, '/'));
        if (!substitutedPath.equals(path)) {
            return substitutedPath;
        }
        if (baseDir != null) {
            File base;
            try {
                base = baseDir.getCanonicalFile();
            }
            catch (IOException e) {
                base = baseDir;
            }
            String relativepath = FileUtil.getRelativePath(base, new File(path));
            if (relativepath != null) {
                boolean shouldUseAbsolutePath;
                boolean bl = shouldUseAbsolutePath = useAbsolutePathsForOuterPaths && relativepath.indexOf("..") >= 0;
                if (!shouldUseAbsolutePath) {
                    String _relativePath = relativepath.replace(File.separatorChar, '/');
                    String root = BuildProperties.propertyRef(baseDirPropertyName);
                    return ".".equals(_relativePath) ? root : root + "/" + _relativePath;
                }
            }
        }
        return substitutedPath;
    }

    public static String trimJarSeparator(String path) {
        return path.endsWith("!/") ? path.substring(0, path.length() - "!/".length()) : path;
    }
}

