/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.util.Pair;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeGenerator
extends Generator {
    private final List<Pair<Generator, Integer>> myGenerators = new ArrayList<Pair<Generator, Integer>>();

    public CompositeGenerator() {
    }

    public CompositeGenerator(Generator generator1, Generator generator2, int emptyLinesCount) {
        this.add(generator1);
        this.add(generator2, emptyLinesCount);
    }

    public final void add(Generator generator) {
        this.add(generator, 0);
    }

    public final void add(Generator generator, int emptyLinesCount) {
        this.myGenerators.add(new Pair<Generator, Integer>(generator, new Integer(emptyLinesCount)));
    }

    public void generate(DataOutput out) throws IOException {
        Iterator<Pair<Generator, Integer>> i$ = this.myGenerators.iterator();
        while (i$.hasNext()) {
            Pair<Generator, Integer> myGenerator;
            Pair<Generator, Integer> pair = myGenerator = i$.next();
            CompositeGenerator.crlf(out);
            int emptyLinesCount = pair.getSecond();
            for (int idx = 0; idx < emptyLinesCount; ++idx) {
                CompositeGenerator.crlf(out);
            }
            pair.getFirst().generate(out);
        }
    }

    public final int getGeneratorCount() {
        return this.myGenerators.size();
    }
}

