/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkBuildExtension {
    public abstract boolean haveSelfOutputs(Module[] var1);

    @NotNull
    @NonNls
    public abstract String[] getTargets(ModuleChunk var1);

    public abstract void process(Project var1, ModuleChunk var2, GenerationOptions var3, CompositeGenerator var4);

    public static boolean hasSelfOutput(ModuleChunk chunk) {
        Object[] objects = Extensions.getRootArea().getExtensionPoint("com.intellij.antBuildGen").getExtensions();
        Module[] modules = chunk.getModules();
        for (Object object : objects) {
            if (((ChunkBuildExtension)object).haveSelfOutputs(modules)) continue;
            return false;
        }
        return true;
    }

    public static String[] getAllTargets(ModuleChunk chunk) {
        Object[] objects;
        ArrayList<String> allTargets = new ArrayList<String>();
        for (Object object : objects = Extensions.getRootArea().getExtensionPoint("com.intellij.antBuildGen").getExtensions()) {
            String[] targets = ((ChunkBuildExtension)object).getTargets(chunk);
            allTargets.addAll(Arrays.asList(targets));
        }
        if (allTargets.isEmpty()) {
            allTargets.add(BuildProperties.getCompileTargetName(chunk.getName()));
        }
        return allTargets.toArray(new String[allTargets.size()]);
    }

    public static void process(CompositeGenerator generator, ModuleChunk chunk, GenerationOptions genOptions) {
        Object[] objects;
        Project project = chunk.getProject();
        for (Object object : objects = Extensions.getRootArea().getExtensionPoint("com.intellij.antBuildGen").getExtensions()) {
            ((ChunkBuildExtension)object).process(project, chunk, genOptions, generator);
        }
    }
}

