/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.util.Chunk;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleCompilerUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.compiler.ModuleCompilerUtil");

    private ModuleCompilerUtil() {
    }

    public static Module[] getDependencies(Module module) {
        return ModuleRootManager.getInstance(module).getDependencies();
    }

    private static Graph<Module> createModuleGraph(final Module[] modules) {
        return GraphGenerator.create(CachingSemiGraph.create(new GraphGenerator.SemiGraph<Module>(){

            @Override
            public Collection<Module> getNodes() {
                return Arrays.asList(modules);
            }

            @Override
            public Iterator<Module> getIn(Module module) {
                return Arrays.asList(ModuleCompilerUtil.getDependencies(module)).iterator();
            }
        }));
    }

    public static List<Chunk<Module>> getSortedModuleChunks(Project project, Module[] modules) {
        Module[] allModules = ModuleManager.getInstance(project).getModules();
        return ModuleCompilerUtil.getSortedModuleChunks(modules, ModuleCompilerUtil.createModuleGraph(allModules));
    }

    public static List<Chunk<Module>> getSortedModuleChunks(Module[] modules, Graph<Module> moduleGraph) {
        List<Chunk<Module>> chunks = ModuleCompilerUtil.getSortedChunks(moduleGraph);
        HashSet<Module> modulesSet = new HashSet<Module>(Arrays.asList(modules));
        Iterator<Chunk<Module>> it = chunks.iterator();
        while (it.hasNext()) {
            Chunk<Module> chunk = it.next();
            if (ModuleCompilerUtil.intersects(chunk.getNodes(), modulesSet)) continue;
            it.remove();
        }
        return chunks;
    }

    public static boolean intersects(Set set1, Set set2) {
        for (Object item : set1) {
            if (!set2.contains(item)) continue;
            return true;
        }
        return false;
    }

    public static <Node> List<Chunk<Node>> getSortedChunks(Graph<Node> _graph) {
        Graph<Chunk<Node>> chunkGraph = ModuleCompilerUtil.toChunkGraph(_graph);
        ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(chunkGraph.getNodes().size());
        for (Chunk<Node> chunk : chunkGraph.getNodes()) {
            chunks.add(chunk);
        }
        DFSTBuilder<Chunk<Chunk<Node>>> builder = new DFSTBuilder<Chunk<Chunk<Node>>>(chunkGraph);
        if (!builder.isAcyclic()) {
            LOG.error("Acyclic graph expected");
            return null;
        }
        Collections.sort(chunks, builder.comparator());
        return chunks;
    }

    public static <Node> Graph<Chunk<Node>> toChunkGraph(final Graph<Node> graph) {
        final DFSTBuilder<Node> builder = new DFSTBuilder<Node>(graph);
        TIntArrayList sccs = builder.getSCCs();
        final ArrayList chunks = new ArrayList(sccs.size());
        final LinkedHashMap nodeToChunkMap = new LinkedHashMap();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                LinkedHashSet chunkNodes = new LinkedHashSet();
                Chunk chunk = new Chunk(chunkNodes);
                chunks.add(chunk);
                for (int j = 0; j < size; ++j) {
                    Object node = builder.getNodeByTNumber(this.myTNumber + j);
                    chunkNodes.add(node);
                    nodeToChunkMap.put(node, chunk);
                }
                this.myTNumber += size;
                return true;
            }
        });
        return GraphGenerator.create(CachingSemiGraph.create(new GraphGenerator.SemiGraph<Chunk<Node>>(){

            @Override
            public Collection<Chunk<Node>> getNodes() {
                return chunks;
            }

            @Override
            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                return ins.iterator();
            }
        }));
    }

    public static void sortModules(final Project project, final List<Module> modules) {
        Application application = ApplicationManager.getApplication();
        Runnable sort = new Runnable(){

            public void run() {
                Comparator<Module> comparator = ModuleManager.getInstance(project).moduleDependencyComparator();
                Collections.sort(modules, comparator);
            }
        };
        if (application.isDispatchThread()) {
            sort.run();
        } else {
            application.runReadAction(sort);
        }
    }
}

