/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefUtil {
    public static RefUtil getInstance() {
        return ServiceManager.getService(RefUtil.class);
    }

    public abstract boolean belongsToScope(PsiElement var1, RefManager var2);

    @Nullable
    public abstract RefPackage getPackage(RefEntity var1);

    public abstract RefClass getTopLevelClass(RefElement var1);

    public abstract boolean isInheritor(RefClass var1, RefClass var2);

    @Nullable
    public abstract String getPackageName(RefEntity var1);

    public abstract String getQualifiedName(RefEntity var1);

    public abstract String getAccessModifier(PsiModifierListOwner var1);

    @Nullable
    public abstract RefClass getOwnerClass(RefManager var1, PsiElement var2);

    @Nullable
    public abstract RefClass getOwnerClass(RefElement var1);

    public abstract int compareAccess(String var1, String var2);

    public abstract void removeRefElement(RefElement var1, List<RefElement> var2);

    public abstract void setAccessModifier(RefElement var1, String var2);

    public abstract void setIsStatic(RefElement var1, boolean var2);

    public abstract void setIsFinal(RefElement var1, boolean var2);

    public abstract boolean isMethodOnlyCallsSuper(PsiMethod var1);

    public static boolean isEntryPoint(RefElement refElement) {
        ImplicitUsageProvider[] implicitUsageProviders;
        Object[] addins;
        for (Object entryPoint : addins = Extensions.getRootArea().getExtensionPoint("com.intellij.entryPoint").getExtensions()) {
            if (!((EntryPoint)entryPoint).accept(refElement)) continue;
            return true;
        }
        PsiElement element = refElement.getElement();
        for (ImplicitUsageProvider provider : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions(ImplicitUsageProvider.EP_NAME)) {
            if (!provider.isImplicitUsage(element)) continue;
            return true;
        }
        return false;
    }
}

