/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlSuppressableInspectionTool
extends CustomSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + XmlSuppressableInspectionTool.class.getName());
    @NonNls
    private static final String SUPPRESS_PREFIX = "<!--suppress ";
    @NonNls
    private static final String SUPPRESS_SUFFIX = " -->\n";
    @NonNls
    private static final String ALL = "ALL";

    @Override
    public IntentionAction[] getSuppressActions(PsiElement element) {
        XmlTag tag = PsiTreeUtil.getContextOfType(element, XmlTag.class, false);
        if (tag != null) {
            return new IntentionAction[]{new SuppressTag(tag), new SuppressForFile(), new SuppressAllForFile()};
        }
        return new IntentionAction[]{new SuppressForFile(), new SuppressAllForFile()};
    }

    @Override
    public boolean isSuppressedFor(PsiElement element) {
        PsiElement leaf;
        XmlTag tag = PsiTreeUtil.getContextOfType(element, XmlTag.class, false);
        if (tag == null) {
            return false;
        }
        PsiElement prev = tag.getPrevSibling();
        while (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        while (prev instanceof PsiComment || prev instanceof XmlProlog || prev instanceof XmlText) {
            String text = prev.getText();
            if (this.isSuppressedFor(text)) {
                return true;
            }
            prev = prev.getPrevSibling();
        }
        XmlFile file = (XmlFile)tag.getContainingFile();
        XmlDocument document = file.getDocument();
        XmlTag rootTag = document != null ? document.getRootTag() : null;
        PsiElement psiElement = leaf = rootTag != null ? rootTag.getPrevSibling() : file.findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getPrevSibling();
        }
        while (leaf instanceof PsiComment || leaf instanceof XmlProlog || leaf instanceof XmlText) {
            String text = leaf.getText();
            if (this.isSuppressedFor(text)) {
                return true;
            }
            leaf = leaf.getPrevSibling();
        }
        return false;
    }

    private boolean isSuppressedFor(@NonNls String text) {
        String[] parts = text.split("[ ,]");
        return text.contains(SUPPRESS_PREFIX) && (ArrayUtil.find(parts, this.getID()) != -1 || ArrayUtil.find(parts, ALL) != -1);
    }

    private void suppress(PsiFile file, @Nullable XmlTag rootTag) {
        XmlSuppressableInspectionTool.suppress(file, rootTag, SUPPRESS_PREFIX + this.getID() + SUPPRESS_SUFFIX, new Function<String, String>(){

            @Override
            public String fun(String text) {
                return text.replaceAll(XmlSuppressableInspectionTool.SUPPRESS_SUFFIX, ", " + XmlSuppressableInspectionTool.this.getID() + XmlSuppressableInspectionTool.SUPPRESS_SUFFIX);
            }
        });
    }

    private static void suppress(PsiFile file, @Nullable XmlTag rootTag, String suppressComment, Function<String, String> replace) {
        PsiElement leaf;
        Project project = file.getProject();
        if (ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(file.getVirtualFile()).hasReadonlyFiles()) {
            return;
        }
        Document doc = PsiDocumentManager.getInstance(project).getDocument(file);
        LOG.assertTrue(doc != null);
        PsiElement psiElement = leaf = rootTag != null ? rootTag.getPrevSibling() : file.findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getPrevSibling();
        }
        while (leaf instanceof PsiComment || leaf instanceof XmlProlog || leaf instanceof XmlText) {
            String text = leaf.getText();
            if (text.contains(SUPPRESS_PREFIX)) {
                TextRange textRange = leaf.getTextRange();
                doc.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), replace.fun(text));
                return;
            }
            leaf = leaf.getPrevSibling();
        }
        int offset = rootTag != null ? rootTag.getTextRange().getStartOffset() : 0;
        doc.insertString(offset, suppressComment);
        CodeStyleManager.getInstance(project).adjustLineIndent(doc, offset + suppressComment.length());
        UndoManager.getInstance(file.getProject()).markDocumentForUndo(file);
    }

    public static class SuppressAllForFile
    implements IntentionAction {
        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getText() {
            String string = InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile.getText must not return null");
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(Project project, Editor editor, PsiFile file) {
            return file instanceof XmlFile && file.isValid();
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            XmlDocument document = ((XmlFile)file).getDocument();
            XmlTag rootTag = document != null ? document.getRootTag() : null;
            String suppressComment = "<!--suppress ALL -->\n";
            XmlSuppressableInspectionTool.suppress(file, rootTag, "<!--suppress ALL -->\n", new Function<String, String>(){

                @Override
                public String fun(String s) {
                    return s.substring(0, s.indexOf(XmlSuppressableInspectionTool.SUPPRESS_PREFIX)) + "<!--suppress ALL -->\n";
                }
            });
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    public class SuppressForFile
    implements IntentionAction {
        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getText() {
            String string = InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile.getText must not return null");
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(Project project, Editor editor, PsiFile file) {
            return file instanceof XmlFile && file.isValid();
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            XmlDocument document = ((XmlFile)file).getDocument();
            XmlSuppressableInspectionTool.this.suppress(file, document != null ? document.getRootTag() : null);
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    public class SuppressTag
    implements IntentionAction {
        private XmlTag myTag;

        public SuppressTag(XmlTag tag) {
            this.myTag = tag;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getText() {
            String string = InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTag.getText must not return null");
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTag.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(Project project, Editor editor, PsiFile file) {
            return this.myTag != null && this.myTag.isValid();
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            XmlSuppressableInspectionTool.this.suppress(file, this.myTag);
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

