/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemsHolder {
    private final InspectionManager myManager;
    private List<ProblemDescriptor> myProblems = null;

    public ProblemsHolder(InspectionManager manager) {
        this.myManager = manager;
    }

    public void registerProblem(PsiElement psiElement, String descriptionTemplate, LocalQuickFix ... fixes) {
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    public void registerProblem(PsiElement psiElement, String descriptionTemplate, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, descriptionTemplate, fixes, highlightType));
    }

    public void registerProblem(ProblemDescriptor problemDescriptor) {
        if (this.myProblems == null) {
            this.myProblems = new ArrayList<ProblemDescriptor>(1);
        }
        this.myProblems.add(problemDescriptor);
    }

    public void registerProblem(PsiReference reference, String descriptionTemplate, ProblemHighlightType highlightType) {
        if (this.myProblems == null) {
            this.myProblems = new ArrayList<ProblemDescriptor>(1);
        }
        LocalQuickFix[] fixes = null;
        if (reference instanceof LocalQuickFixProvider) {
            fixes = ((LocalQuickFixProvider)((Object)reference)).getQuickFixes();
        }
        this.myProblems.add(this.myManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), descriptionTemplate, highlightType, fixes));
    }

    @Nullable
    public List<ProblemDescriptor> getResults() {
        List<ProblemDescriptor> problems = this.myProblems;
        this.myProblems = null;
        return problems;
    }

    public final InspectionManager getManager() {
        return this.myManager;
    }

    public boolean hasResults() {
        return this.myProblems != null && !this.myProblems.isEmpty();
    }
}

