/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationFix
implements IntentionAction,
LocalQuickFix {
    private final String myAnnotation;
    private final PsiModifierListOwner myModifierListOwner;
    private final String[] myAnnotationsToRemove;
    private static final Logger LOG = Logger.getInstance("#" + AddAnnotationFix.class.getName());

    public AddAnnotationFix(String fqn, PsiModifierListOwner modifierListOwner, String ... annotationsToRemove) {
        this.myAnnotation = fqn;
        this.myModifierListOwner = modifierListOwner;
        this.myAnnotationsToRemove = annotationsToRemove;
    }

    public AddAnnotationFix(String fqn, String ... annotationsToRemove) {
        this(fqn, (PsiModifierListOwner)null, annotationsToRemove);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getText() {
        String string;
        String name;
        String shortName = this.myAnnotation.substring(this.myAnnotation.lastIndexOf(46) + 1);
        if (this.myModifierListOwner instanceof PsiNamedElement && (name = ((PsiNamedElement)((Object)this.myModifierListOwner)).getName()) != null) {
            FindUsagesProvider provider = this.myModifierListOwner.getLanguage().getFindUsagesProvider();
            string = CodeInsightBundle.message("inspection.i18n.quickfix.annotate.element.as", provider.getType(this.myModifierListOwner), name, shortName);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/AddAnnotationFix.getText must not return null");
            return string;
        }
        string = this.myModifierListOwner != null ? CodeInsightBundle.message("inspection.i18n.quickfix.annotate.as", shortName) : CodeInsightBundle.message("add.external.annotation.test", shortName);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/AddAnnotationFix.getText must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/AddAnnotationFix.getName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message("intention.add.annotation.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/AddAnnotationFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/AddAnnotationFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/AddAnnotationFix.applyFix must not be null");
        }
        try {
            this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    @Nullable
    protected static PsiModifierListOwner getContainer(Editor editor, PsiFile file) {
        PsiIdentifier psiIdentifier;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner listOwner = PsiTreeUtil.getParentOfType(element, PsiParameter.class, false);
        if (listOwner == null && (psiIdentifier = PsiTreeUtil.getParentOfType(element, PsiIdentifier.class, false)) != null && psiIdentifier.getParent() instanceof PsiModifierListOwner) {
            listOwner = (PsiModifierListOwner)psiIdentifier.getParent();
        }
        return listOwner;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/AddAnnotationFix.isAvailable must not be null");
        }
        if (LanguageLevel.JDK_1_5.compareTo(PsiUtil.getLanguageLevel(file)) > 0) {
            return false;
        }
        if (this.myModifierListOwner != null) {
            if (!this.myModifierListOwner.isValid()) {
                return false;
            }
            if ((!PsiManager.getInstance(project).isInProject(this.myModifierListOwner) || this.myModifierListOwner.getModifierList() == null) && this.myModifierListOwner.isPhysical()) {
                return false;
            }
            owner = this.myModifierListOwner;
        } else {
            owner = !file.getManager().isInProject(file) ? AddAnnotationFix.getContainer(editor, file) : null;
        }
        return owner != null && !AnnotationUtil.isAnnotated(owner, this.myAnnotation, false);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/AddAnnotationFix.invoke must not be null");
        }
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
        if (this.myModifierListOwner != null) {
            PsiModifierList modifierList = this.myModifierListOwner.getModifierList();
            LOG.assertTrue(modifierList != null);
            if (modifierList.findAnnotation(this.myAnnotation) != null) {
                return;
            }
            ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = annotationsManager.chooseAnnotationsPlace(this.myModifierListOwner);
            if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
                return;
            }
            if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
                for (String fqn : this.myAnnotationsToRemove) {
                    annotationsManager.deannotate(this.myModifierListOwner, fqn);
                }
                annotationsManager.annotateExternally(this.myModifierListOwner, this.myAnnotation, file);
            } else {
                PsiFile containingFile = this.myModifierListOwner.getContainingFile();
                if (!containingFile.isWritable() && ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(containingFile.getVirtualFile()).hasReadonlyFiles()) {
                    return;
                }
                for (String fqn : this.myAnnotationsToRemove) {
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation(this.myModifierListOwner, fqn);
                    if (annotation == null) continue;
                    annotation.delete();
                }
                PsiManager manager = file.getManager();
                PsiElementFactory factory = manager.getElementFactory();
                PsiAnnotation annotation = factory.createAnnotationFromText("@" + this.myAnnotation, this.myModifierListOwner);
                PsiElement inserted = modifierList.addAfter(annotation, null);
                CodeStyleManager.getInstance(project).shortenClassReferences(inserted);
                if (containingFile != file) {
                    UndoManager.getInstance(project).markDocumentForUndo(file);
                }
            }
        } else {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            annotationsManager.annotateExternally(PsiTreeUtil.getParentOfType(element, PsiModifierListOwner.class, false), this.myAnnotation, file);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

