/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.HighlightDisplayKey");
    private static final HashMap<String, HighlightDisplayKey> ourMap = new HashMap();
    private static final Map<HighlightDisplayKey, String> ourKeyToDisplayNameMap = new HashMap<HighlightDisplayKey, String>();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls String name) {
        return (HighlightDisplayKey)ourMap.get(name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls String name) {
        if (HighlightDisplayKey.find(name) != null) {
            LOG.info("Key with name '" + name + "' already registered");
            return null;
        }
        return new HighlightDisplayKey(name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls String name, String displayName, @NonNls String id) {
        if (HighlightDisplayKey.find(name) != null) {
            LOG.info("Key with name '" + name + "' already registered");
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls String name, String displayName) {
        return HighlightDisplayKey.register(name, displayName, name);
    }

    public static String getDisplayNameByKey(HighlightDisplayKey key) {
        return ourKeyToDisplayNameMap.get(key);
    }

    private HighlightDisplayKey(String name) {
        this(name, name);
    }

    public HighlightDisplayKey(@NonNls String name, @NonNls String ID) {
        this.myName = name;
        this.myID = ID;
        ourMap.put(this.myName, this);
    }

    public String toString() {
        return this.myName;
    }

    public String getID() {
        return this.myID;
    }
}

