/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TestFramework;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class TestUtil {
    public static final ExtensionPointName<TestFramework> TEST_FRAMEWORK = ExtensionPointName.create((String)"com.intellij.testFramework");

    private TestUtil() {
    }

    public static boolean isTestClass(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = (TestFramework[])Extensions.getExtensions(TEST_FRAMEWORK)) {
            if (!framework.isTestKlass(psiClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiMethod findSetUpMethod(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = (TestFramework[])Extensions.getExtensions(TEST_FRAMEWORK)) {
            if (!framework.isTestKlass(psiClass)) continue;
            try {
                PsiMethod setUpMethod = framework.findSetUpMethod(psiClass);
                if (setUpMethod == null) continue;
                return setUpMethod;
            }
            catch (IncorrectOperationException e) {
                // empty catch block
            }
        }
        return null;
    }
}

