/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiEquivalenceUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.PsiEquivalenceUtil");

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, boolean areCommentsSignificant) {
        PsiElement[] children2;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/PsiEquivalenceUtil.areElementsEquivalent must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/PsiEquivalenceUtil.areElementsEquivalent must not be null");
        }
        if (element1 == element2) {
            return true;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren(element1, areCommentsSignificant);
        if (children1.length != (children2 = PsiEquivalenceUtil.getFilteredChildren(element2, areCommentsSignificant)).length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (PsiEquivalenceUtil.areElementsEquivalent(child1, child2, resolvedElementsComparator, areCommentsSignificant)) continue;
            return false;
        }
        if (children1.length == 0 && !element1.textMatches(element2)) {
            return false;
        }
        PsiReference ref1 = element1.getReference();
        if (ref1 != null) {
            PsiElement resolved2;
            PsiReference ref2 = element2.getReference();
            if (ref2 == null) {
                return false;
            }
            PsiElement resolved1 = ref1.resolve();
            if (!(Comparing.equal(resolved1, resolved2 = ref2.resolve()) || resolvedElementsComparator != null && resolvedElementsComparator.compare(resolved1, resolved2) == 0)) {
                return false;
            }
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/PsiEquivalenceUtil.areElementsEquivalent must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/PsiEquivalenceUtil.areElementsEquivalent must not be null");
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, null, false);
    }

    private static PsiElement[] getFilteredChildren(PsiElement element1, boolean areCommentsSignificant) {
        ASTNode[] children1 = element1.getNode().getChildren(null);
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode node : children1) {
            PsiElement child = node.getPsi();
            if (child instanceof PsiWhiteSpace || !areCommentsSignificant && child instanceof PsiComment) continue;
            array.add(child);
        }
        return array.toArray(new PsiElement[array.size()]);
    }

    public static void findChildRangeDuplicates(PsiElement first, PsiElement last, List<Pair<PsiElement, PsiElement>> result, PsiElement scope) {
        LOG.assertTrue(first.getParent() == last.getParent());
        LOG.assertTrue(!(first instanceof PsiWhiteSpace) && !(last instanceof PsiWhiteSpace));
        PsiEquivalenceUtil.addRangeDuplicates(scope, first, last, result);
    }

    private static void addRangeDuplicates(PsiElement scope, PsiElement first, PsiElement last, List<Pair<PsiElement, PsiElement>> result) {
        PsiElement[] children = PsiEquivalenceUtil.getFilteredChildren(scope, true);
        int i = 0;
        block0: while (i < children.length) {
            PsiElement child = children[i];
            if (child != first) {
                int j = i;
                PsiElement next = first;
                while (PsiEquivalenceUtil.areElementsEquivalent(children[j], next)) {
                    ++j;
                    if (next == last) {
                        result.add(new Pair<PsiElement, PsiElement>(child, children[j - 1]));
                        i = j + 1;
                        continue block0;
                    }
                    next = PsiTreeUtil.skipSiblingsForward(next, PsiWhiteSpace.class);
                }
                if (i == j) {
                    PsiEquivalenceUtil.addRangeDuplicates(child, first, last, result);
                }
            }
            ++i;
        }
    }
}

