/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static PsiMethod getAnyAbstractMethod(PsiClass aClass, Collection<HierarchicalMethodSignature> allMethodsCollection) {
        PsiMethod[] methods;
        PsiMethod methodToImplement = ClassUtil.getAnyMethodToImplement(aClass, allMethodsCollection);
        if (methodToImplement != null) {
            return methodToImplement;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return method;
        }
        return ClassUtil.abstractPackageLocalMethod(aClass, allMethodsCollection);
    }

    private static PsiMethod abstractPackageLocalMethod(PsiClass aClass, Collection<HierarchicalMethodSignature> allMethodsCollection) {
        THashSet allMethods = new THashSet(Arrays.asList(aClass.getAllMethods()));
        THashSet suspects = new THashSet();
        for (HierarchicalMethodSignature signature : allMethodsCollection) {
            ClassUtil.removeSupers(signature, (Set<PsiMethod>)allMethods, (Set<PsiMethod>)suspects);
            PsiMethod method = signature.getMethod();
            if (method.hasModifierProperty("abstract")) {
                suspects.add(method);
            }
            allMethods.remove(method);
        }
        while (!allMethods.isEmpty()) {
            PsiMethod method = (PsiMethod)allMethods.iterator().next();
            ClassUtil.removeSupers(method.getHierarchicalMethodSignature(), (Set<PsiMethod>)allMethods, (Set<PsiMethod>)suspects);
            if (method.hasModifierProperty("abstract")) {
                suspects.add(method);
            }
            allMethods.remove(method);
        }
        return suspects.isEmpty() ? null : (PsiMethod)suspects.iterator().next();
    }

    private static void removeSupers(HierarchicalMethodSignature hierarchicalMethodSignature, Set<PsiMethod> allMethods, Set<PsiMethod> suspects) {
        for (HierarchicalMethodSignature superS : hierarchicalMethodSignature.getSuperSignatures()) {
            PsiMethod superMethod = superS.getMethod();
            allMethods.remove(superMethod);
            suspects.remove(superMethod);
            assert (superS != hierarchicalMethodSignature);
            ClassUtil.removeSupers(superS, allMethods, suspects);
        }
    }

    public static PsiMethod getAnyMethodToImplement(PsiClass aClass, Collection<HierarchicalMethodSignature> allMethodsCollection) {
        for (HierarchicalMethodSignature signatureHierarchical : allMethodsCollection) {
            PsiMethod method = signatureHierarchical.getMethod();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) continue;
            if (!aClass.equals(containingClass) && method.hasModifierProperty("abstract") && !method.hasModifierProperty("static") && !method.hasModifierProperty("private")) {
                return method;
            }
            PsiResolveHelper resolveHelper = aClass.getManager().getResolveHelper();
            List<HierarchicalMethodSignature> superSignatures = signatureHierarchical.getSuperSignatures();
            for (HierarchicalMethodSignature superSignatureHierarchical : superSignatures) {
                PsiMethod superMethod = superSignatureHierarchical.getMethod();
                if (!superMethod.hasModifierProperty("abstract") || resolveHelper.isAccessible(superMethod, method, null)) continue;
                return superMethod;
            }
        }
        return null;
    }
}

