/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    @NonNls
    public static final String NOT_NULL_SIMPLE_NAME = "NotNull";
    @NonNls
    public static final String NULLABLE_SIMPLE_NAME = "Nullable";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    @NonNls
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    @NonNls
    public static final String NON_NLS_SIMPLE_NAME = "NonNls";
    @NonNls
    public static final String PROPERTY_KEY_SIMPLE_NAME = "PropertyKey";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    @NonNls
    public static final String TEST_ONLY_SIMPLE_NAME = "TestOnly";
    public static final Set<String> ALL_ANNOTATIONS = new HashSet<String>(2);

    public static boolean isNullable(PsiModifierListOwner owner) {
        return !AnnotationUtil.isNotNull(owner) && AnnotationUtil.isAnnotated(owner, NULLABLE, true);
    }

    public static boolean isNotNull(PsiModifierListOwner owner) {
        return AnnotationUtil.isAnnotated(owner, NOT_NULL, true);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, String ... annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, new HashSet<String>(Arrays.asList(annotationNames)));
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, Set<String> annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        PsiAnnotation[] allAnnotations;
        if (listOwner instanceof PsiParameter) {
            allAnnotations = ((PsiParameter)listOwner).getAnnotations();
        } else {
            if (listOwner == null) {
                return null;
            }
            PsiModifierList list = listOwner.getModifierList();
            if (list == null) {
                return null;
            }
            allAnnotations = list.getAnnotations();
        }
        for (PsiAnnotation annotation : allAnnotations) {
            String qualifiedName = annotation.getQualifiedName();
            if (!annotationNames.contains(qualifiedName)) continue;
            return annotation;
        }
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(listOwner.getProject());
        for (String annotationName : annotationNames) {
            PsiAnnotation annotation;
            annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotation[] findAnnotations(PsiMember psiMember, Collection<String> annotationNames) {
        PsiAnnotation[] psiAnnotationArray;
        if (psiMember == null) {
            psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
            if (PsiAnnotation.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/AnnotationUtil.findAnnotations must not return null");
            return psiAnnotationArray;
        }
        PsiModifierList modifierList = psiMember.getModifierList();
        if (modifierList == null) {
            psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
            if (PsiAnnotation.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/AnnotationUtil.findAnnotations must not return null");
            return psiAnnotationArray;
        }
        PsiAnnotation[] annotations = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            result.add(psiAnnotation);
        }
        psiAnnotationArray = result.size() == 0 ? PsiAnnotation.EMPTY_ARRAY : result.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray != null) return psiAnnotationArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/AnnotationUtil.findAnnotations must not return null");
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, Set<String> annotationNames) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        if (!(listOwner instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)listOwner;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
        return AnnotationUtil.findAnnotationInHierarchy(methodSignature, annotationNames, method);
    }

    private static PsiAnnotation findAnnotationInHierarchy(HierarchicalMethodSignature signature, Set<String> annotationNames, PsiElement place) {
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        PsiResolveHelper resolveHelper = place.getManager().getResolveHelper();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null)) continue;
            PsiAnnotation direct = AnnotationUtil.findAnnotation((PsiModifierListOwner)superMethod, annotationNames);
            if (direct != null) {
                return direct;
            }
            PsiAnnotation superResult = AnnotationUtil.findAnnotationInHierarchy(superSignature, annotationNames, place);
            if (superResult == null) continue;
            return superResult;
        }
        return null;
    }

    public static boolean isAnnotated(PsiModifierListOwner listOwner, Collection<String> annotations) {
        for (String annotation : annotations) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isAnnotated must not be null");
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, new HashSet<PsiMethod>());
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, Set<PsiMethod> processed) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isAnnotated must not be null");
        }
        if (listOwner instanceof PsiParameter) {
            PsiAnnotation[] paramAnnotations;
            for (PsiAnnotation annotation : paramAnnotations = ((PsiParameter)listOwner).getAnnotations()) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return true;
            }
        } else {
            PsiModifierList modifierList = listOwner.getModifierList();
            if (modifierList == null) {
                return false;
            }
            PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
            if (annotation != null) {
                return true;
            }
        }
        if (ExternalAnnotationsManager.getInstance(listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
            return true;
        }
        if (checkHierarchy && listOwner instanceof PsiMethod) {
            PsiMethod[] superMethods;
            PsiMethod method = (PsiMethod)listOwner;
            if (processed.contains(method)) {
                return false;
            }
            processed.add(method);
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, checkHierarchy, processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(PsiElement elt) {
        return PsiUtil.getLanguageLevel(elt).compareTo(LanguageLevel.JDK_1_5) >= 0 && elt.getManager().findClass(NULLABLE, elt.getResolveScope()) != null;
    }

    public static boolean isJetbrainsAnnotation(@NonNls String simpleName) {
        return NOT_NULL_SIMPLE_NAME.equals(simpleName) || NULLABLE_SIMPLE_NAME.equals(simpleName) || NON_NLS_SIMPLE_NAME.equals(simpleName) || PROPERTY_KEY_SIMPLE_NAME.equals(simpleName) || TEST_ONLY_SIMPLE_NAME.equals(simpleName);
    }

    static {
        ALL_ANNOTATIONS.add(NULLABLE);
        ALL_ANNOTATIONS.add(NOT_NULL);
    }
}

