/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    protected final Document myDocument;
    protected final Project myProject;
    private final long myInitialStamp;
    private int[] myCompletionPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
    private int[] myStartingPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
    private int myId;

    protected TextEditorHighlightingPass(Project project, @Nullable Document document) {
        this.myDocument = document;
        this.myProject = project;
        this.myInitialStamp = document == null ? 0L : document.getModificationStamp();
    }

    @Deprecated
    protected TextEditorHighlightingPass(Document document) {
        this(null, document);
    }

    public final void collectInformation(ProgressIndicator progress) {
        if (!this.isValid()) {
            return;
        }
        this.doCollectInformation(progress);
    }

    public boolean isValid() {
        PsiFile file;
        if (this.myDocument != null && this.myDocument.getModificationStamp() != this.myInitialStamp) {
            return false;
        }
        return this.myProject == null || this.myDocument == null || (file = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument)) != null && file.isValid();
    }

    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        this.doApplyInformationToEditor();
    }

    public abstract void doCollectInformation(ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    @Deprecated
    public int getPassId() {
        return this.myId;
    }

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id) {
        this.myId = id;
    }

    @NotNull
    public final int[] getCompletionPredecessorIds() {
        if (this.myCompletionPredecessorIds == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeHighlighting/TextEditorHighlightingPass.getCompletionPredecessorIds must not return null");
        }
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(@NotNull int[] completionPredecessorIds) {
        if (completionPredecessorIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeHighlighting/TextEditorHighlightingPass.setCompletionPredecessorIds must not be null");
        }
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public final int[] getStartingPredecessorIds() {
        if (this.myStartingPredecessorIds == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeHighlighting/TextEditorHighlightingPass.getStartingPredecessorIds must not return null");
        }
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(@NotNull int[] startingPredecessorIds) {
        if (startingPredecessorIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeHighlighting/TextEditorHighlightingPass.setStartingPredecessorIds must not be null");
        }
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return this.getClass() + "; id=" + this.getId();
    }
}

