/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FileIndexImplUtil;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance("#com.intellij.analysis.AnalysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int PACKAGE = 5;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static int UNCOMMITED_FILES = 10;
    private final Project myProject;
    private final List<Module> myModules;
    private final Module myModule;
    private final PsiElement myElement;
    private final SearchScope myScope;
    private boolean mySearchInLibraries = false;
    private final int myType;
    private HashSet<VirtualFile> myFilesSet;
    private boolean myIncludeTestSource = true;

    public AnalysisScope(Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
    }

    public AnalysisScope(Module module) {
        this.myProject = null;
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
    }

    public AnalysisScope(Module[] modules) {
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = null;
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
    }

    public AnalysisScope(PsiDirectory psiDirectory) {
        this.myProject = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
    }

    public AnalysisScope(PsiPackage psiPackage) {
        this.myProject = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myElement = psiPackage;
        this.myType = 5;
    }

    public AnalysisScope(PsiFile psiFile) {
        this.myProject = null;
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
    }

    public AnalysisScope(SearchScope scope, Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public AnalysisScope(Project project, Collection<VirtualFile> virtualFiles) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myFilesSet = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    private PsiElementVisitor createFileSearcher() {
        final FileIndex fileIndex = this.myProject != null ? ProjectRootManager.getInstance(this.myProject).getFileIndex() : (this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : (this.myModules != null && !this.myModules.isEmpty() ? ProjectRootManager.getInstance(this.myModules.get(0).getProject()).getFileIndex() : (this.myElement != null ? ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex() : null)));
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return new PsiRecursiveElementVisitor(){

            public void visitFile(PsiFile file) {
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (!AnalysisScope.this.myIncludeTestSource && (fileIndex == null || fileIndex.isInTestSourceContent(virtualFile))) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile);
                    if (indicator != null) {
                        indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
                        indicator.setText2(VfsUtil.calcRelativeToProjectPath(virtualFile, file.getProject()));
                    }
                }
            }
        };
    }

    public boolean contains(PsiElement psiElement) {
        return this.contains(psiElement.getContainingFile().getVirtualFile());
    }

    public boolean contains(VirtualFile file) {
        if (this.myFilesSet == null) {
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && (this.myIncludeTestSource || !index.isInTestSourceContent(file));
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    private void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 5 || this.myType == 8) {
            this.myFilesSet = new HashSet();
            this.accept(this.createFileSearcher());
        }
    }

    public AnalysisScope[] getNarrowedComplementaryScope(Project defaultProject) {
        VirtualFile vFile;
        if (this.myType == 1 || this.myType == 8) {
            return new AnalysisScope[]{new AnalysisScope(defaultProject)};
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3) {
            if (this.myElement instanceof PsiJavaFile && !PsiUtil.isInJspFile(this.myElement)) {
                PsiDirectory psiDirectory;
                PsiJavaFile psiJavaFile = (PsiJavaFile)this.myElement;
                PsiClass[] classes = psiJavaFile.getClasses();
                boolean onlyPackLocalClasses = true;
                for (PsiClass aClass : classes) {
                    if (!aClass.hasModifierProperty("public")) continue;
                    onlyPackLocalClasses = false;
                }
                if (onlyPackLocalClasses && (psiDirectory = psiJavaFile.getContainingDirectory()) != null) {
                    return new AnalysisScope[]{new AnalysisScope(psiDirectory.getPackage())};
                }
            }
            vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 2) {
            vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 5) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiPackage)this.myElement).getDirectories()) {
                modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, directory.getVirtualFile()));
            }
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        if (modules.isEmpty()) {
            return new AnalysisScope[]{new AnalysisScope(defaultProject)};
        }
        HashSet<AnalysisScope> result = new HashSet<AnalysisScope>();
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        for (Module module : modules) {
            Set<Module> modulesToAnalyze = AnalysisScope.getDirectBackwardDependencies(module, allModules);
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
            result.add(new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()])));
        }
        return result.toArray(new AnalysisScope[result.size()]);
    }

    private static Set<Module> getExportBackwardDependencies(Module fromModule, Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        return result;
    }

    private static Set<Module> getDirectBackwardDependencies(Module module, Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find(ModuleRootManager.getInstance(dependency).getDependencies(), module) <= -1) continue;
            result.add(dependency);
        }
        return result;
    }

    private static HashSet<Module> getAllInterestingModules(ProjectFileIndex fileIndex, VirtualFile vFile) {
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        return modules;
    }

    public void accept(PsiElementVisitor visitor) {
        this.accept(visitor, !ApplicationManager.getApplication().isReadAccessAllowed());
    }

    private void accept(final PsiElementVisitor visitor, final boolean needReadAction) {
        if (this.myType == 9) {
            PsiManager psiManager = PsiManager.getInstance(this.myProject);
            for (VirtualFile file : this.myFilesSet) {
                if (AnalysisScope.processFile(file, visitor, psiManager, needReadAction)) continue;
                return;
            }
        } else if (this.myScope instanceof GlobalSearchScope) {
            final PsiManager psiManager = PsiManager.getInstance(this.myProject);
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            ContentIterator contentIterator = new ContentIterator(){

                public boolean processFile(final VirtualFile fileOrDir) {
                    if (fileOrDir.isDirectory()) {
                        return true;
                    }
                    boolean isInScope = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                        @Override
                        public Boolean compute() {
                            return ((GlobalSearchScope)AnalysisScope.this.myScope).contains(fileOrDir);
                        }
                    });
                    if (isInScope && (AnalysisScope.this.myIncludeTestSource || !projectFileIndex.isInTestSourceContent(fileOrDir))) {
                        return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
                    }
                    return true;
                }
            };
            projectFileIndex.iterateContent(contentIterator);
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    FileIndexImplUtil.iterateRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator);
                }
            }
        } else if (this.myScope instanceof LocalSearchScope) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                public void run() {
                    PsiElement[] psiElements;
                    for (PsiElement element : psiElements = ((LocalSearchScope)AnalysisScope.this.myScope).getScope()) {
                        element.accept(visitor);
                    }
                }
            });
        } else if (this.myProject != null) {
            final PsiManager psiManager = PsiManager.getInstance(this.myProject);
            final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            projectFileIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    return AnalysisScope.this.processFile(fileOrDir, visitor, projectFileIndex, psiManager, needReadAction);
                }
            });
        } else if (this.myModule != null) {
            final ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(this.myModule).getFileIndex();
            final PsiManager psiManager = PsiManager.getInstance(this.myModule.getProject());
            moduleFileIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    return AnalysisScope.this.processFile(fileOrDir, visitor, moduleFileIndex, psiManager, needReadAction);
                }
            });
        } else if (this.myModules != null) {
            for (Module module : this.myModules) {
                final PsiManager psiManager = PsiManager.getInstance(module.getProject());
                final ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                moduleFileIndex.iterateContent(new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        return AnalysisScope.this.processFile(fileOrDir, visitor, moduleFileIndex, psiManager, needReadAction);
                    }
                });
            }
        } else if (this.myElement instanceof PsiPackage) {
            final PsiPackage pack = (PsiPackage)this.myElement;
            final HashSet dirs = new HashSet();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                public void run() {
                    dirs.addAll(Arrays.asList(pack.getDirectories(GlobalSearchScope.projectScope(AnalysisScope.this.myElement.getProject()))));
                }
            });
            for (PsiDirectory dir : dirs) {
                this.accept(dir, visitor, needReadAction);
            }
        } else if (this.myElement instanceof PsiDirectory) {
            this.accept((PsiDirectory)this.myElement, visitor, needReadAction);
        } else {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                public void run() {
                    AnalysisScope.this.myElement.accept(visitor);
                }
            });
        }
    }

    private boolean processFile(VirtualFile fileOrDir, PsiElementVisitor visitor, FileIndex projectFileIndex, PsiManager psiManager, boolean needReadAction) {
        if (fileOrDir.isDirectory()) {
            return true;
        }
        if (projectFileIndex.isInContent(fileOrDir) && (this.myIncludeTestSource || !projectFileIndex.isInTestSourceContent(fileOrDir))) {
            return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
        }
        return true;
    }

    private static boolean processFile(VirtualFile fileOrDir, final PsiElementVisitor visitor, final PsiManager psiManager, boolean needReadAction) {
        final PsiFile file = AnalysisScope.getPsiFileInReadAction(psiManager, fileOrDir);
        if (file == null) {
            return true;
        }
        if (needReadAction) {
            PsiDocumentManager.getInstance(psiManager.getProject()).commitAndRunReadAction(new Runnable(){

                public void run() {
                    file.accept(visitor);
                    psiManager.dropResolveCaches();
                }
            });
        } else {
            file.accept(visitor);
            psiManager.dropResolveCaches();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private void accept(@NotNull PsiDirectory dir, final @NotNull PsiElementVisitor visitor, final boolean needReadAction) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/AnalysisScope.accept must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/analysis/AnalysisScope.accept must not be null");
        }
        Project project = dir.getProject();
        final PsiManager psiManager = PsiManager.getInstance(project);
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        index.iterateContentUnderDirectory(dir.getVirtualFile(), new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (!AnalysisScope.this.myIncludeTestSource && index.isInTestSourceContent(fileOrDir)) {
                    return true;
                }
                if (!fileOrDir.isDirectory()) {
                    return AnalysisScope.processFile(fileOrDir, visitor, psiManager, needReadAction);
                }
                return true;
            }
        });
    }

    public boolean isValid() {
        if (this.myProject != null) {
            return true;
        }
        if (this.myModule != null && !this.myModule.isDisposed()) {
            return true;
        }
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        return this.myType == 9 || this.myType == 8 || this.myElement != null && this.myElement.isValid();
    }

    public int getScopeType() {
        return this.myType;
    }

    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, new Function<Module, String>(){

                    @Override
                    public String fun(Module module) {
                        return AnalysisScope.pathToName(module.getModuleFilePath());
                    }
                }, ", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", AnalysisScope.pathToName(this.myProject.getPresentableUrl()));
            }
            case 3: {
                VirtualFile virtualFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                return AnalysisScopeBundle.message("scope.file", virtualFile.getPresentableUrl());
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", ((PsiFileSystemItem)this.myElement).getVirtualFile().getPresentableUrl());
            }
            case 5: {
                return AnalysisScopeBundle.message("scope.package", ((PsiPackage)this.myElement).getQualifiedName());
            }
        }
        return "";
    }

    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, new Function<Module, String>(){

                    @Override
                    public String fun(Module module) {
                        return module.getName();
                    }
                }, ", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                return AnalysisScopeBundle.message("scope.file", VfsUtil.calcRelativeToProjectPath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject()));
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", VfsUtil.calcRelativeToProjectPath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject()));
            }
            case 5: {
                return AnalysisScopeBundle.message("scope.package", ((PsiPackage)this.myElement).getQualifiedName());
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
            }
        }
        return "";
    }

    private static String pathToName(String path) {
        String name = path;
        if (path != null) {
            File file = new File(path);
            name = FileUtil.getNameWithoutExtension(file);
        }
        return name;
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    public void invalidate() {
        if (this.myType != 9) {
            this.myFilesSet = null;
        } else {
            Iterator<VirtualFile> i = this.myFilesSet.iterator();
            while (i.hasNext()) {
                VirtualFile virtualFile = i.next();
                if (virtualFile != null && virtualFile.isValid()) continue;
                i.remove();
            }
        }
    }

    public Set<String> getActiveInspectionProfiles() {
        HashSet<String> result;
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    result = new HashSet<String>();
                                    if (this.myType != 1 && this.myType != 8) break block4;
                                    ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(this.myProject, "INSPECTION");
                                    LOG.assertTrue(profileManager != null);
                                    if (profileManager.useProjectLevelProfileSettings()) {
                                        result.addAll(profileManager.getProfilesUsedInProject().values());
                                        result.add(profileManager.getProjectProfile());
                                    } else {
                                        ApplicationProfileManager applicationProfileManager = ApplicationProfileManager.getProfileManager("INSPECTION");
                                        LOG.assertTrue(applicationProfileManager != null);
                                        result.add(applicationProfileManager.getRootProfile().getName());
                                    }
                                    break block5;
                                }
                                if (this.myType != 4) break block6;
                                AnalysisScope.processModule(result, this.myModule);
                                break block5;
                            }
                            if (this.myType != 7) break block7;
                            for (Module module : this.myModules) {
                                AnalysisScope.processModule(result, module);
                            }
                            break block5;
                        }
                        if (this.myType != 3) break block8;
                        ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(this.myElement.getProject(), "INSPECTION");
                        LOG.assertTrue(profileManager != null);
                        result.add(profileManager.getProfileName((PsiFile)this.myElement));
                        break block5;
                    }
                    if (this.myType != 2) break block9;
                    ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(this.myElement.getProject(), "INSPECTION");
                    LOG.assertTrue(profileManager != null);
                    AnalysisScope.processDirectories(new PsiDirectory[]{(PsiDirectory)this.myElement}, result, profileManager);
                    break block5;
                }
                if (this.myType != 5) break block10;
                ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(this.myElement.getProject(), "INSPECTION");
                LOG.assertTrue(profileManager != null);
                PsiDirectory[] psiDirectories = ((PsiPackage)this.myElement).getDirectories();
                AnalysisScope.processDirectories(psiDirectories, result, profileManager);
                break block5;
            }
            if (this.myType != 9) break block5;
            ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(this.myProject, "INSPECTION");
            PsiManager psiManager = PsiManager.getInstance(this.myProject);
            LOG.assertTrue(profileManager != null);
            for (VirtualFile file : this.myFilesSet) {
                PsiFile psiFile = AnalysisScope.getPsiFileInReadAction(psiManager, file);
                if (psiFile == null || !psiFile.isValid()) continue;
                result.add(profileManager.getProfileName(psiFile));
            }
        }
        return result;
    }

    private static PsiFile getPsiFileInReadAction(final PsiManager psiManager, final VirtualFile file) {
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiFile>(){

            @Override
            @Nullable
            public PsiFile compute() {
                return psiManager.findFile(file);
            }
        });
    }

    private static void processDirectories(PsiDirectory[] psiDirectories, Set<String> result, ProjectProfileManager profileManager) {
        for (final PsiDirectory directory : psiDirectories) {
            PsiFile[] psiFiles;
            for (PsiFile file : psiFiles = ApplicationManager.getApplication().runReadAction(new Computable<PsiFile[]>(){

                @Override
                public PsiFile[] compute() {
                    return directory.getFiles();
                }
            })) {
                result.add(profileManager.getProfileName(file));
            }
            AnalysisScope.processDirectories(ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory[]>(){

                @Override
                public PsiDirectory[] compute() {
                    return directory.getSubdirectories();
                }
            }), result, profileManager);
        }
    }

    private static void processModule(Set<String> result, Module module) {
        Project project = module.getProject();
        ProjectProfileManager profileManager = ProjectProfileManager.getProjectProfileManager(project, "INSPECTION");
        LOG.assertTrue(profileManager != null);
        VirtualFile[] files = ModuleRootManager.getInstance(module).getContentRoots();
        PsiDirectory[] dirs = new PsiDirectory[files.length];
        final PsiManager psiManager = PsiManager.getInstance(project);
        int i = 0;
        for (final VirtualFile file : files) {
            dirs[i++] = ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

                @Override
                @Nullable
                public PsiDirectory compute() {
                    return psiManager.findDirectory(file);
                }
            });
        }
        AnalysisScope.processDirectories(dirs, result, profileManager);
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest ? index.isInTestSourceContent(directory) : !index.isInTestSourceContent(directory);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest ? index.isInTestSourceContent(file) : !index.isInTestSourceContent(file);
            }
        }
        return true;
    }
}

