/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReverseListIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    @CodingStyleguideUnaware
    private final List<? extends ELEMENTTYPE> m_aList;
    private int m_nIndex;

    public ReverseListIterator(@Nonnull List<? extends ELEMENTTYPE> list) {
        this.m_aList = ValueEnforcer.notNull(list, "List");
        this.m_nIndex = list.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex >= 0;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_nIndex < 0) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aList.get(this.m_nIndex);
        --this.m_nIndex;
        return ELEMENTTYPE;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringGenerator(this).append("list", this.m_aList).append("index", this.m_nIndex).getToString();
    }
}

