/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsOrderedMap<KEYTYPE, VALUETYPE>
extends ICommonsMap<KEYTYPE, VALUETYPE> {
    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <K, V> ICommonsOrderedMap<K, V> createInstance() {
        return new CommonsLinkedHashMap();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet() {
        return new CommonsLinkedHashSet(this.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        return CollectionHelper.newOrderedSet(this.keySet(), predicate);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        return new CommonsLinkedHashSet(this.entrySet());
    }

    @Nullable
    default public KEYTYPE getLastKey() {
        return this.getLastKey(null);
    }

    @Nullable
    default public KEYTYPE getLastKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : CollectionHelper.getLastElement(this.keySet()));
    }

    @Nullable
    default public VALUETYPE getLastValue() {
        return this.getLastValue(null);
    }

    @Nullable
    default public VALUETYPE getLastValue(@Nullable VALUETYPE VALUETYPE) {
        KEYTYPE KEYTYPE = this.getLastKey();
        return (VALUETYPE)(KEYTYPE == null ? VALUETYPE : this.get(KEYTYPE));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<KEYTYPE, VALUETYPE> getClone();
}

