/*
 * Decompiled with CFR 0.152.
 */
package com.zen.elasticjob.spring.boot.jobinit;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.api.dataflow.DataflowJob;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.dangdang.ddframe.job.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import com.zen.elasticjob.spring.boot.ElasticJobProperties;
import java.util.ArrayList;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;

public abstract class AbstractJobInitialization
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void initJob(String jobName, JobType jobType, ElasticJobProperties.JobConfiguration configuration) {
        ElasticJob elasticJob = this.registerElasticJob(jobName, configuration.getJobClass(), jobType);
        ZookeeperRegistryCenter regCenter = this.getZookeeperRegistryCenter(configuration.getRegistryCenterRef());
        JobCoreConfiguration jobCoreConfiguration = this.getJobCoreConfiguration(jobName, configuration);
        JobTypeConfiguration jobTypeConfiguration = this.getJobTypeConfiguration(jobName, jobCoreConfiguration);
        LiteJobConfiguration liteJobConfiguration = this.getLiteJobConfiguration(jobTypeConfiguration, configuration);
        JobEventRdbConfiguration jobEventRdbConfiguration = this.getJobEventRdbConfiguration(configuration.getEventTraceRdbDataSource());
        ElasticJobListener[] elasticJobListeners = this.creatElasticJobListeners(configuration.getListener());
        ElasticJobListener[] elasticJobListenerArray = elasticJobListeners = null == elasticJobListeners ? new ElasticJobListener[]{} : elasticJobListeners;
        if (null == jobEventRdbConfiguration) {
            new SpringJobScheduler(elasticJob, (CoordinatorRegistryCenter)regCenter, liteJobConfiguration, elasticJobListeners).init();
        } else {
            new SpringJobScheduler(elasticJob, (CoordinatorRegistryCenter)regCenter, liteJobConfiguration, (JobEventConfiguration)jobEventRdbConfiguration, elasticJobListeners).init();
        }
    }

    public abstract JobTypeConfiguration getJobTypeConfiguration(String var1, JobCoreConfiguration var2);

    private ElasticJob registerElasticJob(String jobName, String strClass, JobType jobType) {
        switch (jobType) {
            case SIMPLE: {
                return (ElasticJob)this.registerBean(jobName, strClass, SimpleJob.class, new Object[0]);
            }
            case DATAFLOW: {
                return (ElasticJob)this.registerBean(jobName, strClass, DataflowJob.class, new Object[0]);
            }
        }
        return null;
    }

    private ZookeeperRegistryCenter getZookeeperRegistryCenter(String registryCenterRef) {
        if (StringUtils.isBlank((CharSequence)registryCenterRef)) {
            registryCenterRef = "elasticJobRegistryCenter";
        }
        if (!this.applicationContext.containsBean(registryCenterRef)) {
            throw new RuntimeException("not exist ZookeeperRegistryCenter [" + registryCenterRef + "] !");
        }
        return (ZookeeperRegistryCenter)this.applicationContext.getBean(registryCenterRef, ZookeeperRegistryCenter.class);
    }

    private JobEventRdbConfiguration getJobEventRdbConfiguration(String eventTraceRdbDataSource) {
        if (StringUtils.isBlank((CharSequence)eventTraceRdbDataSource)) {
            return null;
        }
        if (!this.applicationContext.containsBean(eventTraceRdbDataSource)) {
            throw new RuntimeException("not exist datasource [" + eventTraceRdbDataSource + "] !");
        }
        DataSource dataSource = (DataSource)this.applicationContext.getBean(eventTraceRdbDataSource);
        return new JobEventRdbConfiguration(dataSource);
    }

    private LiteJobConfiguration getLiteJobConfiguration(JobTypeConfiguration jobTypeConfiguration, ElasticJobProperties.JobConfiguration jobConfiguration) {
        return LiteJobConfiguration.newBuilder((JobTypeConfiguration)Objects.requireNonNull(jobTypeConfiguration)).monitorExecution(jobConfiguration.isMonitorExecution()).monitorPort(jobConfiguration.getMonitorPort()).maxTimeDiffSeconds(jobConfiguration.getMaxTimeDiffSeconds()).jobShardingStrategyClass(jobConfiguration.getJobShardingStrategyClass()).reconcileIntervalMinutes(jobConfiguration.getReconcileIntervalMinutes()).disabled(jobConfiguration.isDisabled()).overwrite(jobConfiguration.isOverwrite()).build();
    }

    protected JobCoreConfiguration getJobCoreConfiguration(String jobName, ElasticJobProperties.JobConfiguration jobConfiguration) {
        JobCoreConfiguration.Builder builder = JobCoreConfiguration.newBuilder((String)jobName, (String)jobConfiguration.getCron(), (int)jobConfiguration.getShardingTotalCount()).shardingItemParameters(jobConfiguration.getShardingItemParameters()).jobParameter(jobConfiguration.getJobParameter()).failover(jobConfiguration.isFailover()).misfire(jobConfiguration.isMisfire()).description(jobConfiguration.getDescription());
        if (StringUtils.isNotBlank((CharSequence)jobConfiguration.getJobExceptionHandler())) {
            builder.jobProperties(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), jobConfiguration.getJobExceptionHandler());
        }
        if (StringUtils.isNotBlank((CharSequence)jobConfiguration.getExecutorServiceHandler())) {
            builder.jobProperties(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), jobConfiguration.getExecutorServiceHandler());
        }
        return builder.build();
    }

    private ElasticJobListener[] creatElasticJobListeners(ElasticJobProperties.JobConfiguration.Listener listener) {
        AbstractDistributeOnceElasticJobListener distributedListener;
        if (null == listener) {
            return null;
        }
        ArrayList<Object> elasticJobListeners = new ArrayList<Object>(2);
        ElasticJobListener elasticJobListener = this.registerBean(listener.getListenerClass(), listener.getListenerClass(), ElasticJobListener.class, new Object[0]);
        if (null != elasticJobListener) {
            elasticJobListeners.add(elasticJobListener);
        }
        if (null != (distributedListener = this.registerBean(listener.getDistributedListenerClass(), listener.getDistributedListenerClass(), AbstractDistributeOnceElasticJobListener.class, listener.getStartedTimeoutMilliseconds(), listener.getCompletedTimeoutMilliseconds()))) {
            elasticJobListeners.add(distributedListener);
        }
        if (CollectionUtils.isEmpty(elasticJobListeners)) {
            return null;
        }
        ElasticJobListener[] elasticJobListenerArray = new ElasticJobListener[elasticJobListeners.size()];
        for (int i = 0; i < elasticJobListeners.size(); ++i) {
            elasticJobListenerArray[i] = (ElasticJobListener)elasticJobListeners.get(i);
        }
        return elasticJobListenerArray;
    }

    protected <T> T registerBean(String beanName, String strClass, Class<T> tClass, Object ... constructorArgValue) {
        if (StringUtils.isBlank((CharSequence)strClass)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)beanName)) {
            beanName = strClass;
        }
        if (this.applicationContext.containsBean(beanName)) {
            return (T)this.applicationContext.getBean(beanName, tClass);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)strClass);
        beanDefinitionBuilder.setScope("prototype");
        for (Object argValue : constructorArgValue) {
            beanDefinitionBuilder.addConstructorArgValue(argValue);
        }
        this.getDefaultListableBeanFactory().registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        return (T)this.applicationContext.getBean(beanName, tClass);
    }

    private DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
    }
}

