/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.util;

import io.swagger.annotations.DynamicParameter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    static Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    static final String basePackage = "com.github.xiaoymin.swaggerbootstrapui.model.";
    static final ClassPool classPool = ClassPool.getDefault();

    public static String UpperCase(String str) {
        StringBuffer aa = new StringBuffer();
        int index = 0;
        int index22 = 0;
        int len = str.length();
        for (int i = 1; i < len; ++i) {
            if (Character.isUpperCase(str.charAt(i))) {
                if (Character.isUpperCase(str.charAt(i + 1))) {
                    aa.append(str.substring(index, i)).append("");
                } else {
                    aa.append(str.substring(index, i)).append(" ");
                }
                index = i;
                ++index22;
                continue;
            }
            index22 = 0;
        }
        aa.append(str.substring(index, len));
        return aa.toString();
    }

    public static byte[] readBytes(File file) {
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new RuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException("File length is [" + len + "] but read [" + readLength + "]!");
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.closeQuiltly(in);
                throw throwable;
            }
        }
        CommonUtils.closeQuiltly(in);
        return bytes;
    }

    public static byte[] readBytes(InputStream ins) {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream byteOutArr = new ByteArrayOutputStream();
        int r = -1;
        byte[] bytes = new byte[0x100000];
        try {
            while ((r = ins.read(bytes)) != -1) {
                byteOutArr.write(bytes, 0, r);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CommonUtils.closeQuiltly(ins);
        }
        return byteOutArr.toByteArray();
    }

    public static void closeQuiltly(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void closeQuiltly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Class<?> createDynamicModelClass(String name, DynamicParameter[] parameters) {
        String clazzName = basePackage + name;
        try {
            CtClass tmp = classPool.getCtClass(clazzName);
            if (tmp != null) {
                tmp.detach();
            }
        }
        catch (NotFoundException tmp) {
            // empty catch block
        }
        CtClass ctClass = classPool.makeClass(clazzName);
        try {
            for (DynamicParameter dynamicParameter : parameters) {
                ctClass.addField(CommonUtils.createField(dynamicParameter, ctClass));
            }
            return ctClass.toClass();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static CtField createField(DynamicParameter parameter, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtField field = new CtField(CommonUtils.getFieldType(parameter.dataTypeClass()), parameter.name(), ctClass);
        field.setModifiers(1);
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation ann = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
        ann.addMemberValue("value", (MemberValue)new StringMemberValue(parameter.value(), constPool));
        ann.addMemberValue("required", (MemberValue)new BooleanMemberValue(parameter.required(), constPool));
        if (parameter.example() != null && !"".equals(parameter.example())) {
            ann.addMemberValue("example", (MemberValue)new StringMemberValue(parameter.example(), constPool));
        }
        attr.addAnnotation(ann);
        field.getFieldInfo().addAttribute((AttributeInfo)attr);
        return field;
    }

    private static CtClass getFieldType(Class<?> propetyType) {
        CtClass fieldType = null;
        try {
            fieldType = !propetyType.isAssignableFrom(Void.class) ? classPool.get(propetyType.getName()) : classPool.get(String.class.getName());
        }
        catch (NotFoundException e) {
            ClassClassPath path = new ClassClassPath(propetyType);
            classPool.insertClassPath((ClassPath)path);
            try {
                fieldType = classPool.get(propetyType.getName());
            }
            catch (NotFoundException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return fieldType;
    }
}

