/*
 * Decompiled with CFR 0.152.
 */
package org.treeleafj.xdoc.boot;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.treeleafj.xdoc.XDoc;
import org.treeleafj.xdoc.boot.XDocProperties;
import org.treeleafj.xdoc.framework.Framework;
import org.treeleafj.xdoc.model.ApiDoc;
import org.treeleafj.xdoc.spring.framework.SpringWebFramework;
import org.treeleafj.xdoc.utils.JsonUtils;

@RequestMapping(value={"xdoc"})
public class XDocController {
    private Logger log = LoggerFactory.getLogger(XDocController.class);
    @Autowired
    private XDocProperties xDocProperties;
    private static ApiDoc apiDoc;

    @PostConstruct
    public void init() {
        if (!this.xDocProperties.isEnable()) {
            return;
        }
        String path = this.xDocProperties.getSourcePath();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = ".";
        }
        List<String> paths = Arrays.asList(path.split(","));
        this.log.debug("starting XDoc, source path:{}", paths);
        try {
            XDoc xDoc = new XDoc(paths, (Framework)new SpringWebFramework());
            Thread thread = new Thread(() -> {
                try {
                    apiDoc = xDoc.resolve();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("version", this.xDocProperties.getVersion());
                    properties.put("title", this.xDocProperties.getTitle());
                    apiDoc.setProperties(properties);
                    this.log.info("start up XDoc");
                }
                catch (Exception e) {
                    this.log.error("start up XDoc error", (Throwable)e);
                }
            });
            thread.start();
        }
        catch (Exception e) {
            this.log.error("start up XDoc error", (Throwable)e);
        }
    }

    @GetMapping
    public String index() {
        return "redirect:index.html";
    }

    @ResponseBody
    @RequestMapping(value={"apis"})
    public Object apis() {
        return JsonUtils.toJson((Object)apiDoc);
    }

    @GetMapping(value={"rebuild"})
    public String rebuild() {
        this.init();
        return "redirect:index.html";
    }
}

