/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3Util {
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType FORM_DATA = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");

    public static String syncGet(String url) {
        return OkHttp3Util.doSyncGet(url, null, null);
    }

    public static void asyncGet(String url, Callback callback) {
        OkHttp3Util.doAsyncGet(url, null, null, callback);
    }

    public static String syncGet(String baseUrl, Map<String, String> params) {
        return OkHttp3Util.doSyncGet(baseUrl, params, null);
    }

    public static void asyncGet(String baseUrl, Map<String, String> params, Callback callback) {
        OkHttp3Util.doAsyncGet(baseUrl, params, null, callback);
    }

    public static String syncGet(String baseUrl, Map<String, String> params, Map<String, String> headers) {
        return OkHttp3Util.doSyncGet(baseUrl, params, headers);
    }

    public static void asyncGet(String baseUrl, Map<String, String> params, Map<String, String> headers, Callback callback) {
        OkHttp3Util.doAsyncGet(baseUrl, params, headers, callback);
    }

    public static String syncPost(String url, Map<String, String> params) {
        return OkHttp3Util.doSyncPost(url, params, null);
    }

    public static void asyncPost(String url, Map<String, String> params, Callback callback) {
        OkHttp3Util.doAsyncPost(url, params, null, callback);
    }

    public static String syncPost(String url, Map<String, String> params, Map<String, String> headers) {
        return OkHttp3Util.doSyncPost(url, params, headers);
    }

    public static void asyncPost(String url, Map<String, String> params, Map<String, String> headers, Callback callback) {
        OkHttp3Util.doAsyncPost(url, params, headers, callback);
    }

    public static String syncPostJson(String url, String json) {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
        return OkHttp3Util.doSyncPost(url, body, null);
    }

    public static void asyncPostJson(String url, String json, Callback callback) {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
        OkHttp3Util.doAsyncPost(url, body, null, callback);
    }

    public static String syncPostJson(String url, String json, Map<String, String> headersMap) {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
        return OkHttp3Util.doSyncPost(url, body, headersMap);
    }

    public static void asyncPostJson(String url, String json, Map<String, String> headersMap, Callback callback) {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
        OkHttp3Util.doAsyncPost(url, body, headersMap, callback);
    }

    private static void doAsyncGet(String baseUrl, Map<String, String> params, Map<String, String> headersMap, Callback callback) {
        Request request;
        OkHttpClient client = OkHttp3Util.getInstance();
        String url = OkHttp3Util.urlJoin(baseUrl, params);
        if (null == headersMap || headersMap.size() == 0) {
            request = new Request.Builder().url(url).build();
        } else {
            Headers headers = OkHttp3Util.setHeaders(headersMap);
            request = new Request.Builder().url(url).headers(headers).build();
        }
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    private static String doSyncGet(String baseUrl, Map<String, String> params, Map<String, String> headersMap) {
        Request request;
        OkHttpClient client = OkHttp3Util.getInstance();
        String url = OkHttp3Util.urlJoin(baseUrl, params);
        if (null == headersMap || headersMap.size() == 0) {
            request = new Request.Builder().url(url).build();
        } else {
            Headers headers = OkHttp3Util.setHeaders(headersMap);
            request = new Request.Builder().url(url).headers(headers).build();
        }
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void doAsyncPost(String url, Map<String, String> params, Map<String, String> headersMap, Callback callback) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        FormBody body = builder.build();
        OkHttp3Util.doAsyncPost(url, (RequestBody)body, headersMap, callback);
    }

    private static String doSyncPost(String url, Map<String, String> params, Map<String, String> headersMap) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        FormBody body = builder.build();
        return OkHttp3Util.doSyncPost(url, (RequestBody)body, headersMap);
    }

    private static void doAsyncPost(String url, RequestBody body, Map<String, String> headersMap, Callback callback) {
        Request request;
        OkHttpClient client = OkHttp3Util.getInstance();
        if (null == headersMap || headersMap.size() == 0) {
            request = new Request.Builder().post(body).url(url).build();
        } else {
            Headers headers = OkHttp3Util.setHeaders(headersMap);
            request = new Request.Builder().post(body).url(url).headers(headers).build();
        }
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    private static String doSyncPost(String url, RequestBody body, Map<String, String> headersMap) {
        Request request;
        OkHttpClient client = OkHttp3Util.getInstance();
        if (null == headersMap || headersMap.size() == 0) {
            request = new Request.Builder().post(body).url(url).build();
        } else {
            Headers headers = OkHttp3Util.setHeaders(headersMap);
            request = new Request.Builder().post(body).url(url).headers(headers).build();
        }
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Headers setHeaders(Map<String, String> headersParams) {
        Headers.Builder headersBuilder = new Headers.Builder();
        if (headersParams != null) {
            Iterator<String> iterator = headersParams.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                headersBuilder.add(key, headersParams.get(key));
            }
        }
        Headers headers = headersBuilder.build();
        return headers;
    }

    private static String urlJoin(String url, Map<String, String> params) {
        StringBuilder endUrl = new StringBuilder(url);
        if (null == params) {
            return url;
        }
        boolean isFirst = true;
        Set<Map.Entry<String, String>> entrySet = params.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (isFirst && !url.contains("?")) {
                isFirst = false;
                endUrl.append("?");
            } else {
                endUrl.append("&");
            }
            endUrl.append(entry.getKey());
            endUrl.append("=");
            endUrl.append(entry.getValue());
        }
        return endUrl.toString();
    }

    public static OkHttpClient getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final OkHttpClient INSTANCE = new OkHttpClient.Builder().connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(10000L, TimeUnit.MILLISECONDS).build();

        private SingletonHolder() {
        }
    }
}

