/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.util;

import cn.hutool.core.util.StrUtil;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.plexpt.chatgpt.entity.chat.ChatCompletion;
import com.plexpt.chatgpt.entity.chat.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class TokensUtil {
    private static final Map<String, Encoding> modelEncodingMap = new HashMap<String, Encoding>();
    private static final EncodingRegistry encodingRegistry = Encodings.newDefaultEncodingRegistry();

    public static int tokens(String modelName, List<Message> messages) {
        Encoding encoding = modelEncodingMap.get(modelName);
        if (encoding == null) {
            throw new IllegalArgumentException("Unsupported model: " + modelName);
        }
        int tokensPerMessage = 0;
        int tokensPerName = 0;
        if (modelName.startsWith("gpt-4")) {
            tokensPerMessage = 3;
            tokensPerName = 1;
        } else if (modelName.startsWith("gpt-3.5-turbo")) {
            tokensPerMessage = 4;
            tokensPerName = -1;
        }
        int sum = 0;
        for (Message message : messages) {
            sum += tokensPerMessage;
            sum += encoding.countTokens(message.getContent());
            sum += encoding.countTokens(message.getRole());
            if (!StrUtil.isNotBlank((CharSequence)message.getName())) continue;
            sum += encoding.countTokens(message.getName());
            sum += tokensPerName;
        }
        return sum += 3;
    }

    private TokensUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (ChatCompletion.Model model : ChatCompletion.Model.values()) {
            Optional encodingForModel = encodingRegistry.getEncodingForModel(model.getName());
            encodingForModel.ifPresent(encoding -> modelEncodingMap.put(model.getName(), (Encoding)encoding));
        }
    }
}

